#include "xyz_sensor_platform.h"
#include "envelopetracker.h"

#define BAUD 115200
#define NORMAL_SPEED 2

typedef unsigned char byte;
uint8_t* dataToSend;
int sendArrayIndex = 0;
int sendBufferMax = 10000;
Serial pc(SERIAL_TX, SERIAL_RX, BAUD );
DigitalOut led(LED2),led3(LED3);
DigitalOut mag_test(PC_8);
InterruptIn button(USER_BUTTON);
XYZSensorPlatform platform;
Envelope *command;
EnvelopeTracker tracker;
byte commandToSend[10]= {'H','O','1','2','3','4','5','6','E',0};
Envelope* result;
float x, y, z;
float pos[3];
float speed = (float)NORMAL_SPEED;
bool commandToDo = false;
int recordTime;
bool isEcho = false;
bool isReset = false;

void echo(char typ, float x, float y, float z);
uint8_t* echo(char typ, int16_t *p_data, bool isWriteNow = true);
void Rx_interrupt();

int main()
{
    led=1;
    command = new Envelope;
    command->enableHeader(std::string("H"));// 48 H
    command->enableFooter(std::string("E"),8);// 45 E
    command->enableCheckXOR(9);
    tracker.setEnvelope(*command);
    tracker.setBufferLength(100);
    pc.format(8,SerialBase::None,1);
    platform.set_speed(speed);
// Setup a serial interrupt function to receive data
    pc.attach(&Rx_interrupt, Serial::RxIrq);
//    echo('B',0,0,0);
    while(1) {
        if(isReset){
            isReset = false;
            platform.set_speed(1);
            platform.reset();
            platform.set_speed(speed);
        }
        if(isEcho)
        {
            platform.position(pos);
            echo('O',pos[0],pos[1],pos[2]);
            led3 = !led3;
            isEcho = false;
        }
        if(commandToDo) {
//            printf("%f, %f, %f\n", x,y,z);
            platform.to(x,y,z);
            isEcho = true;
            commandToDo = false;
            continue;
        }
    } // end while

}

void echo(char typ,float x, float y, float z)
{
    int16_t p_data[3]= {(int16_t)(x*10), int16_t(y*10), int16_t(z*10)};
    echo(typ,p_data);
}

uint8_t* echo(char typ, int16_t *p_data, bool isWriteNow)
{
    char tmp[] = {typ, p_data[0]>>8, p_data[0], p_data[1]>>8, p_data[1], p_data[2]>>8, p_data[2]};
    command->setEnvelopeData(tmp,7);
    dataToSend = (uint8_t*)(command->getEnvelopeArray());
    if(isWriteNow)
    {
       int i = 0;
       while(!pc.writeable() && i < 10000) i++;
       for(int i = 0; i < 10; i++) pc.putc(dataToSend[i]);
    }
    return dataToSend;
}

void Rx_interrupt()
{
    char c;
    while(pc.readable()) {
        c = pc.getc();
        tracker.parse(&c,1);

        result = tracker.getEnvelope();
        if(result!=NULL) {
            char *dataArray = result->getPayload();
            switch(dataArray[0]) {
                // following alphabets is used
                // I O C X Y Z M R S P N B
                case 'O': // echo
                    isEcho = true;
                    break;
                case 'C': // command
                    if(commandToDo) break;
                    x=(float)((int(dataArray[1])<<8)+int(dataArray[2]))/10.0f;
                    y=(float)((int(dataArray[3])<<8)+int(dataArray[4]))/10.0f;
                    z=(float)((int(dataArray[5])<<8)+int(dataArray[6]))/10.0f;
                    commandToDo = true;
                    break;
                case 'N': // new set up
                    isReset = true;
                    break;
                case 'V': // set speed
                    speed = float(dataArray[1])/10.0f;
                    platform.set_speed(speed);
                    break;
                default:
                    break;
            } // end switch
            result = NULL;
            dataArray = NULL;
        } // end result if
    } // end parsing if
}
