#include "xyz_sensor_platform.h"

XYZSensorPlatform::XYZSensorPlatform()
{
    Motor* motorX = new AlphaSmart("motorX\0", \
                            MOTOR_X_POUT_DIRECTION, \
                            MOTOR_X_POUT_PULSE, \
                            MOTOR_X_POUT_SV_OFF, \
                            MOTOR_X_POUT_RST, \
                            MOTOR_X_PIN_INP, \
                            MOTOR_X_PIN_RDY, \
                            MOTOR_X_PINT_ALM, \
                            MOTOR_X_PINT_EAP, \
                            MOTOR_X_PIN_EBP, \
                            MOTOR_X_PIN_EZP, \
                            MOTOR_RESOLUTION);
    Motor* motorY = new AlphaSmart("motorY\0", \
                            MOTOR_Y_POUT_DIRECTION, \
                            MOTOR_Y_POUT_PULSE, \
                            MOTOR_Y_POUT_SV_OFF, \
                            MOTOR_Y_POUT_RST, \
                            MOTOR_Y_PIN_INP, \
                            MOTOR_Y_PIN_RDY, \
                            MOTOR_Y_PINT_ALM, \
                            MOTOR_Y_PINT_EAP, \
                            MOTOR_Y_PIN_EBP, \
                            MOTOR_Y_PIN_EZP, \
                            MOTOR_RESOLUTION);
    Motor* motorZ = new AlphaSmart("motorZ\0", \
                            MOTOR_Z_POUT_DIRECTION, \
                            MOTOR_Z_POUT_PULSE, \
                            MOTOR_Z_POUT_SV_OFF, \
                            MOTOR_Z_POUT_RST, \
                            MOTOR_Z_PIN_INP, \
                            MOTOR_Z_PIN_RDY, \
                            MOTOR_Z_PINT_ALM, \
                            MOTOR_Z_PINT_EAP, \
                            MOTOR_X_PIN_EBP, \
                            MOTOR_X_PIN_EZP, \
                            MOTOR_RESOLUTION);
    xSlide = new LinearSlide(motorX, 1.0f, 500, MOTOR_X_PIN_ZERO, MOTOR_X_PIN_END);
    ySlide = new LinearSlide(motorY, 1.0f, 500, MOTOR_Y_PIN_ZERO, MOTOR_Y_PIN_END);
    zSlide = new LinearSlide(motorZ, 0.5f, 100, MOTOR_Z_PIN_ZERO, MOTOR_Z_PIN_END);
    
}
void XYZSensorPlatform::init(void)
{
//    uint8_t id1, id2;
//
//    /* Determine ID of Gyro & Motion Sensor */
//    CALL_METH(gyroscope, read_id, &id1, 0x0);
//    CALL_METH(accelerometer, read_id, &id2, 0x0);
//    printf("\r\ngyr_addr: %p, accer_addr: %p\r\n",gyroscope,accelerometer);
//#ifdef MOTOR_INITIAL
    
//#endif
}    
void XYZSensorPlatform::reset() {
    /** Motor Initial **/
    xSlide->toZero();
    ySlide->toZero();
    zSlide->toZero();
}

void XYZSensorPlatform::to(float x, float y, float z)
{
    zSlide->to(z);
    xSlide->to(x); 
    ySlide->to(y);
}