#ifndef __XYZ_SENSOR_PLATFORM_H
#define __XYZ_SENSOR_PLATFORM_H

/*** Includes ----------------------------------------------------------------- ***/
//#include "mbed.h"
#include "linear_slide.h"
#include "motor_targets.h"
#define MOTOR_INITIAL
//#define CALIBRATION_TIME 100
#define MOTOR_RESOLUTION 200

/*** Typedefs ----------------------------------------------------------------- ***/
typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_TypeDef;


class XYZSensorPlatform
{
public:
    XYZSensorPlatform();
    void init(void);
    void reset(void);
    
    bool isMoving(){ return xSlide->moving() || ySlide->moving() || zSlide->moving(); }
    
    void set_speed(float speed) {
        xSlide->setSpeed(speed);
        ySlide->setSpeed(speed);
        zSlide->setSpeed(speed);
    }
    
    float speed() {
        return xSlide->speed();
    }
    
    void position(float* pos) {
        pos[0] = xSlide->position();
        pos[1] = ySlide->position();
        pos[2] = zSlide->position();
    }
    
    void setPosition(float x, float y, float z) {
        xSlide->setPosition(x);
        ySlide->setPosition(y);
        zSlide->setPosition(z);
    }
        
    
    void to(float x, float y, float z) ;
    
private:
    LinearSlide *xSlide, *ySlide, *zSlide;
};
#endif // __XYZ_SENSOR_PLATFORM_H
