#ifndef SIMPLEENVELOPE_H
#define SIMPLEENVELOPE_H


//#include <QByteArray>
//#include <QString>
#include <string>
class Envelope
{
public:
    Envelope();

    Envelope(const Envelope &);
    Envelope& setEnvelopeData(const char *buf, int bufLength, int checkSumStart=0);

    Envelope& setEnvelopeDataAdjustFooterIndex(const char * buf, int bufLength, int checkSumStart=0);
    // header
    void enableHeader(std::string headervalue, int headerindex=0);

    // footer
    void enableFooter(std::string footervalue, int footerindex);

    // crc
    void enableCRC(int crcindex, int crclength);

    // xor
    void enableCheckXOR(int xorIndex);

    char * getEnvelopeArray();  ///////// need to delete
    char * getHeader() const;  ///////// need to delete

    char * getFooter() const;  ///////// need to delete

    int getHeaderIndex() const;

    int getFooterIndex() const;

    bool checkXOR() const;

    char * getPayload() const;

    int length() const;

    int getPayloadLength() const;

    int getHeaderLength() const;

    int getFooterLength() const;

    Envelope &operator=(const Envelope &);

    bool getHasHeader() const;

    bool getHasFooter() const;

    ~Envelope();

private:
    char generateXor(char * input, int length);
    int appendData(char *toAppend, int startIndex, char *data, int dataLength);

    //header
    bool hasHeader;
    int headerIndex;
    char * headerValue;
    int headerLength;

    // Footer
    bool hasFooter;
    int footerIndex;
    char * footerValue;
    int footerLength;

    // check
    // CRC
    bool hasCRC;
    int checkCRCIndex;
    int checkCRCLength;

    // check xor
    bool hasCheckXOR;
    int checkXORIndex;
    char Xor;

    char * payload;
    int payloadLength;
    int checkSumStart;
    
    char* envelopeArray;

};

#endif // SIMPLEENVELOPE_H


