#ifndef __XYZ_SENSOR_PLATFORM_H
#define __XYZ_SENSOR_PLATFORM_H

/*** Includes ----------------------------------------------------------------- ***/
//#include "mbed.h"
#include "mag_ring.h"
#include "linear_slide.h"
#include "motor_targets.h"
#define MOTOR_INITIAL
//#define CALIBRATION_TIME 100
#define MOTOR_RESOLUTION 200

/*** Typedefs ----------------------------------------------------------------- ***/
typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_TypeDef;

typedef struct {
    AxesRaw_TypeDef Magnetic[NUMBER_OF_MAGNETOMETERS];
} MagneticArray_TypeDef;

class XYZSensorPlatform
{
public:
    XYZSensorPlatform();
    void init(void);
    void reset(void);
    
    void go_forward();
    void go_backward();
    void go_up();
    void go_down();
    void go_right();
    void go_left();
    
    bool isMoving(){ return xSlide->moving() || ySlide->moving() || zSlide->moving(); }
    
    void set_speed(float speed) {
        xSlide->setSpeed(speed);
        ySlide->setSpeed(speed);
        zSlide->setSpeed(speed);
    }
    
    float speed() {
        return xSlide->speed();
    }
    
    void position(float* pos) {
        pos[0] = xSlide->position();
        pos[1] = ySlide->position();
        pos[2] = zSlide->position();
    }
    
    void setPosition(float x, float y, float z) {
        xSlide->setPosition(x);
        ySlide->setPosition(y);
        zSlide->setPosition(z);
    }
        
    
    void to(float x, float y, float z) ;
    
    MagneticArray_TypeDef get_mag() {
        MagneticArray_TypeDef ret;
        magnetometer->get_m_axes((int32_t *)&ret);
        return ret;
    }
    
    int get_mag_raw(int16_t ret[][3]) {
        return sensor->get_m_axes_raw(ret);
    }
    
    int get_mag_raw(int magIndex, int16_t *ret) {
        return sensor->get_m_axes_raw(magIndex, ret);
    }
    
    void resetMagnetometer(int magIndex)
    {
        sensor->resetMagnetometer(magIndex);
    }
    /*
    AxesRaw_TypeDef get_acc(int i) {
        AxesRaw_TypeDef ret;
        sensor->motionArray(i)->get_x_axes((int32_t *)&ret);
        return ret;
    }
    
    AxesRaw_TypeDef get_gyr(int i) {
        AxesRaw_TypeDef ret;
        sensor->gyroArray(i)->get_g_axes((int32_t *)&ret);
        return ret;
    }
    */
    void setSensorSpiFrequency(int hz){ sensor->setSpiFrequency(hz); }
private:
//    void checkMovedTimes();
    LinearSlide *xSlide, *ySlide, *zSlide;
    int _movedTimes;
    DigitalIn xZero, xEnd, yZero, yEnd, zZero, zEnd;
    MagRing *sensor;
    MagneticSensor *magnetometer;
};
#endif // __XYZ_SENSOR_PLATFORM_H
