#include "linear_slide.h"

LinearSlide::LinearSlide(Motor *motor, float pitch, int length, PinName zi, PinName ei):
    _p_motor(motor),
    _length(length),
    _zeroPulseCount(0),
    _pitch(pitch),
    _pos(0.0f),
    _vel(0.0f),
    _zero(zi),
    _end(ei),
    _nextEvent(NULL),
    _isReset(false)
{
    
}

void LinearSlide::go(int dir)
{
    if(moving()) return;
    _dir = dir;
    if(!isInBound()) return;
    int pulseCount = countPulseNumber(0.1); // 1mm
    _p_motor->setRotateFinishEvent(callback(this,&LinearSlide::goCallback));
    _p_motor->setRotateCheckEvent(callback(this,&LinearSlide::isInBound));
    _p_motor->setSpeed((int)(_vel*60.0f/(float)(_pitch)));
    _p_motor->rotate((dir == MOTOR_SIDE ? CCW : CW), pulseCount);
}

void LinearSlide::to(float pos)
{
    if(moving() || (pos == _pos)) return;
    float diffPos = pos-_pos;
//    if(diffPos < 0.01f && diffPos > -0.01f) return;
    Direction dir = (diffPos > 0.0f ? CCW : CW);
    _dir = (dir == CCW ? MOTOR_SIDE : NON_MOTOR_SIDE);
    if(!isInBound()) return;
    diffPos = (diffPos > 0.0f ? diffPos : -diffPos);
    int pulseCount = countPulseNumber(diffPos); 
    _p_motor->setRotateFinishEvent(callback(this,&LinearSlide::goCallback));
    _p_motor->setRotateCheckEvent(callback(this,&LinearSlide::isInBound));
    _p_motor->setSpeed((int)(_vel*60.0f/(float)(_pitch)));
    _p_motor->rotate(dir, pulseCount);
}

inline void LinearSlide::goCallback()
{
    _pos = position();
    if(_nextEvent) _nextEvent();
    _nextEvent = NULL;
    if(_isReset) reset();
    _isReset = false;
}

float LinearSlide::setSpeed(float cmps)
{
    if(moving()){
        _resetVel = cmps;
        return;
    }
    _resetVel = cmps;
    _vel = cmps;
    int rpm = (int)(_vel*60.0f/(float)(_pitch));
    int rpm_set = _p_motor->setSpeed(rpm);
    if(rpm_set != rpm)
    {
        _vel = (float)(rpm_set)*_pitch/60.0f;
    }
    return _vel;
}

inline bool LinearSlide::isInBound()
{
   if((_zero == 0 && _dir == NON_MOTOR_SIDE) || (_end == 0 && _dir == MOTOR_SIDE))
        return false;
   return true;
}

void LinearSlide::toZero()
{
    if(!isInBound()) return;
    _dir = NON_MOTOR_SIDE;
    int pulseCount = countPulseNumber(10); // 10cm
    _p_motor->setRotateFinishEvent(callback(this,&LinearSlide::reset));
    _p_motor->setRotateCheckEvent(callback(this,&LinearSlide::isInBound));
    _p_motor->setSpeed((int)(0.3f*60.0f/(float)(_pitch)));
    _p_motor->rotate(CW, pulseCount);
}

void LinearSlide::toEnd()
{
    _dir = MOTOR_SIDE;
    int pulseCount = countPulseNumber(10); // 10cm
    _p_motor->setRotateCheckEvent(callback(this,&LinearSlide::isInBound));
    _p_motor->setSpeed((int)(0.3f*60.0f/(float)(_pitch)));
    _p_motor->rotate(CCW, pulseCount);
}   

void LinearSlide::initial()
{
    setSpeed(3);
    _nextEvent = callback(this,&LinearSlide::toZero);
    _isReset = true;
    to(_pos+1);
}
