#ifndef __MOTOR_H
#define __MOTOR_H

#include "mbed.h"
//#define ALARM
#define MOTOR_SIDE 1
#define NON_MOTOR_SIDE 0
#define CD_2D34M__TxCM_S 625.0
#define CD_2D24MB__TxCM_S 125.0
#define CD_2D34M__CW 1
#define CD_2D24MB__CW 0



enum Direction{CW,CCW};

class Motor
{
public:
    Motor(PinName p, PinName d, char* n);
    void rotate(Direction direction, int pulseCount);
    int setSpeed(int rpm);
    int speed() {
        return _rpm;
    }
    void reset() {
        if(_lock){
            return;
        }
        _pulseCounter=0;
    }
    bool moving(){ return _lock; }
    void stop(void);
    char* getName(){ return _name; }
    int getResolution(){ return _resolution; }
    int getPulseCounter(){ return _pulseCounter; }
    int getPhase(){ return _phase; }
    void setRotateFinishEvent(Callback<void()> event){
        if(!_rotateFinishEvent) _rotateFinishEvent = event;
    }
    void setRotateCheckEvent(Callback<bool()> event){
        if(!_rotateCheckEvent) _rotateCheckEvent = event;
    }
    virtual void free(){}
    virtual void resume(){}
    virtual void reset_alarm(){}
    
protected:
    void set_cw_signal(int cw){
        cw = (cw > 0 ? 1 : 0);
        _cw = cw;
        _ccw = 1-_cw;
    }
    
    char* _name;
    int _resolution;
    int _phase;
    int _maxRotateSpeed; // in rpm(revolution per minute)
    float _minDelay; // in us
    
private:
    void toggleOn(void);
    void toggleOff(void);
    
    DigitalOut _pulse, _dir;
    Timeout _pulseTimeout;
    int _onDelay;
    int _offDelay;
    int _pulseCounter, _goalPulseCount;
    int _rpm;
    int _cw, _ccw;
    Direction _rotateDirection;
    bool _lock;
    Callback<void()> _rotateFinishEvent;
    Callback<bool()> _rotateCheckEvent;
};

class CD_2D34M: public Motor
{
public:
    CD_2D34M(char* n, PinName d, PinName p, PinName a, PinName r);
private:
    void alarm_event();
    void alarm_reset();
    InterruptIn _alarm;
    DigitalOut _reset;
};

class CD_2D24MB: public Motor
{
public:
    CD_2D24MB(char* n, PinName p, PinName d, PinName m);
private:
    DigitalOut _mf;
};

class AlphaSmart: public Motor
{
public:
    AlphaSmart(char* n, PinName pulse, PinName dir, PinName sv_off, PinName rst, PinName inp, PinName rdy, PinName alm, PinName ea, PinName eb, PinName ez, int res); 
    virtual void free(){
        _sv_off = 0;
    }
    
    virtual void resume(){
        _sv_off = 1;
    }
    
    virtual void reset_alarm(){
        _rst = 0;
        _rst_timeout.attach_us(callback(this,&AlphaSmart::rst_on), 1e3);
    }
    
private:
    void rst_on(){
        _rst = 1;
    }
    DigitalOut _sv_off, _rst;
    DigitalIn _inp, _rdy;
    InterruptIn _alm;
    Timeout _rst_timeout;
};

#endif // __MOTOR_H

