#ifndef __LINEAR_SLIDE_H
#define __LINEAR_SLIDE_H

#include "motor.h"

class LinearSlide
{
public:
    LinearSlide(Motor *motor, float pitch, int length, PinName zi, PinName ei);
    void go(int dir); // move 1mm
    void to(float pos);
    float position(){
        int pulseCounter = _p_motor->getPulseCounter();
        int resolution = _p_motor->getResolution();
        _pos = (float)(_pitch)*(float)(pulseCounter-_zeroPulseCount)/(float)(resolution);
        return _pos;
    }
    bool moving(){ return _p_motor->moving(); }
    void reset(){
        setPosition(0);
        setSpeed(_resetVel);
    }
    float setSpeed(float cmps);
    void setPosition(float cm)
    {
        _zeroPulseCount = countPulseNumber(position()-cm);
        _pos = cm;
    }
    
    float speed(){ return _vel; }
    bool isInBound();
    void toZero();
    void toEnd();
    void initial();
    
private:
    void goCallback();
    int countPulseNumber(float cm){
        int resolution = _p_motor->getResolution();
        return (int)(cm*(float)(resolution)/_pitch);
    }

    Motor *_p_motor;
    int _length; // in mm
    int _zeroPulseCount;
    float _pitch; // in cm
    float _pos;
    float _vel; // in cm/s
    float _resetVel;
    int _dir;
    DigitalIn _zero, _end;
    Callback<void()> _nextEvent;
    bool _isReset;
};

#endif // __LINEAR_SLIDE_H
