#include "envelope.h"
//#include "mbed.h"

Envelope::Envelope()
{
    hasCheckXOR = false;
    hasCRC = false;
    hasFooter = false;
    hasHeader = false;
    payload = NULL;
    //header
    hasHeader = false;
    headerIndex = 0;
    headerValue = NULL;
    headerLength = 0;

    // Footer
    hasFooter = false;
    footerIndex = 0;
    footerValue = NULL;
    footerLength = 0;

    // check
    // CRC
    hasCRC = false;
    checkCRCIndex = 0;
    checkCRCLength = 0;
    // check xor
    hasCheckXOR = false;
    checkXORIndex = 0;

    payload = NULL;
    payloadLength = 0;
    checkSumStart=0;
    envelopeArray = NULL;
}

Envelope::Envelope(const Envelope &en)
{
    *this = en;
}

Envelope& Envelope::setEnvelopeData(const char *buf, int bufLength, int checkSumStart)
{
    if(payload == NULL) payload = new char [payloadLength];
    for(int i = 0; i < payloadLength; i++) {
        if(i < bufLength) payload[i] = buf[i];
        else payload[i] = 0;
    }
    this->checkSumStart=checkSumStart;
    return *this;
}

Envelope& Envelope::setEnvelopeDataAdjustFooterIndex(const char *buf, int bufLength, int checkSumStart)
{
    if(payload) delete payload;
    payload = new char [bufLength];
    for(int i = 0; i < bufLength; i++) payload[i] = buf[i];
    this->checkSumStart=checkSumStart;
    return *this;
}

void Envelope::enableHeader(std::string headervalue, int headerindex)
{
    hasHeader = true;
    headerIndex = headerindex;
    headerLength = headervalue.length();
    if(headerValue) delete headerValue;
    headerValue = new char [headerLength];
    for(int i = 0; i < headerLength; i++) headerValue[i] = headervalue[i];
}

void Envelope::enableFooter(std::string footervalue, int footerindex)
{
    hasFooter = true;
    footerIndex = footerindex;
    footerLength = footervalue.length();
    if(footerValue) delete footerValue;
    footerValue = new char [footerLength];
    for(int i = 0; i < footerLength; i++) footerValue[i] = footervalue[i];
    payloadLength = footerindex - headerLength;
    envelopeArray = new char[length()];
}

void Envelope::enableCheckXOR(int xorIndex)
{
    hasCheckXOR = true;
    checkXORIndex = xorIndex;
}

char * Envelope::getEnvelopeArray()
{
    int envelopeLength = length();
    int i = 0;
    if(hasHeader) i = appendData(envelopeArray, i, headerValue, headerLength);
    i = appendData(envelopeArray, i, payload, payloadLength);
    if(hasFooter) i = appendData(envelopeArray, i, footerValue, footerLength);
    if(hasCheckXOR) envelopeArray[i] = generateXor(envelopeArray, envelopeLength-1);
    return envelopeArray;
}

char Envelope::generateXor(char *input, int length)
{
    Xor = 0;
    for(int i = checkSumStart; i < length; i++) Xor ^= input[i];
    return Xor;
}

int Envelope::appendData(char *toAppend, int startIndex, char *data, int dataLength)
{
    if(toAppend == NULL || data == NULL) return -1; // error
    for(int i = 0; i < dataLength; i++) toAppend[ i + startIndex ] = data[i];
    return startIndex + dataLength;
}

bool Envelope::getHasFooter() const
{
    return hasFooter;
}

Envelope::~Envelope()
{
    if(headerValue) delete headerValue;
    if(footerValue) delete footerValue;
    if(payload) delete payload;
    if(envelopeArray) delete envelopeArray;
}

bool Envelope::getHasHeader() const
{
    return hasHeader;
}

int Envelope::getFooterLength() const
{
    return footerLength;
}

Envelope &Envelope::operator=(const Envelope & en)
{
    hasHeader = en.hasHeader;
    headerLength = en.headerLength;
    headerIndex = en.headerIndex;
    if(headerValue) delete headerValue;
    headerValue = new char[headerLength];
    appendData(headerValue, 0, en.headerValue, headerLength);
//    printf("header replication pass\n");

    hasFooter = en.hasFooter;
    footerLength = en.footerLength;
    footerIndex = en.footerIndex;
    if(footerValue) delete footerValue;
    footerValue = new char[footerLength];
    appendData(footerValue, 0, en.footerValue, footerLength);
//    printf("Footer replication pass\n");

    hasCheckXOR = en.hasCheckXOR;
    checkCRCIndex = en.checkXORIndex;
    Xor = en.Xor;

    payloadLength = en.payloadLength;
    if(payload) delete payload;
    payload = new char[payloadLength];
    appendData(payload, 0, en.payload, payloadLength);
//    printf("payload replication pass\n");

    checkSumStart = en.checkSumStart;
    return *this;
}

int Envelope::getHeaderLength() const
{
    return headerLength;
}

int Envelope::getPayloadLength() const
{
    return payloadLength;
}

char * Envelope::getPayload() const
{
    return payload;
}

int Envelope::length() const
{
    int envelopeLength = payloadLength;
    if(hasHeader) envelopeLength += headerLength;
    if(hasFooter) envelopeLength += footerLength;
    if(hasCheckXOR) envelopeLength++;
    return envelopeLength;
}

bool Envelope::checkXOR() const
{
    return hasCheckXOR;
}

int Envelope::getFooterIndex() const
{
    return footerIndex;
}

int Envelope::getHeaderIndex() const
{
    return headerIndex;
}

char * Envelope::getFooter() const
{
    return footerValue;
}

char * Envelope::getHeader() const
{
    return headerValue;
}

