#include "mbed.h"
#include "PwmBeep.h"

//ポートには数キロΩの抵抗を通して圧電スピーカーを接続してください。
PwmBeep beep(p22);

int main() {
    while(1) {
        beep.turnOn();
        wait(1.0);
        beep.turnOff();
        wait(1.0);
        
        beep.setFreq(1250);
        
        //別の処理が進む
        beep.NshotOn(2, 0.4, 0.1);
        wait(0.2);
        
        beep.setFreq(1500); //NshotOnの途中で実行される
        wait(1.0);
        
        beep.setFreq(1250);
        
        //別の処理が止まる
        beep.NshotOnwithWait(2, 0.4, 0.1); 
        wait(0.2);
        
        beep.setFreq(2000); //NshotOnwithWait終了後実行される
        
        beep.oneshotOn(0.1);
        wait(0.2);
        
        beep.setFreq(1000);
    }
}
