#include "PwmBeep.h"
#include "mbed.h"

//public function

    PwmBeep::PwmBeep(PinName pin,int initialfreq) : _pwmbeep(pin) {
        setFreq(initialfreq);
        _pwmbeep = 0.0;
    }
    
    void PwmBeep::turnOff(){
        _pwmbeep = 0.0;
    }
 
    void PwmBeep::turnOn(){
        _pwmbeep = 0.5;
    }
    
    void PwmBeep::oneshotOn(float time){
        turnOn();
        timeout.attach(callback(this, &PwmBeep::turnOff), time);
    }
    
    void PwmBeep::NshotOn(int num,float ontime,float offtime){
        counter = 0;
        repeat_count = num;
        repeat_ontime = ontime;
        repeat_offtime = offtime;
        turnOn_and_setOffTimer();
    }
    
    void PwmBeep::NshotOnwithWait(int num,float ontime,float offtime){
        for(int i = 0; i < num; i++){
            turnOn();
            wait(ontime);
            turnOff();
            wait(offtime);
        }
    }

    void PwmBeep::setFreq(int freq){
         _pwmbeep.period((float)1.00/freq);  //ms
    }
    
 //private function
   
    void PwmBeep::turnOn_and_setOffTimer(){
        turnOn();
        timeout.attach(callback(this, &PwmBeep::turnOff_and_setOnTimer), repeat_ontime);
        counter++;
    }
    
    void PwmBeep::turnOff_and_setOnTimer(){
        turnOff();
        if(counter < repeat_count){
            timeout.attach(callback(this, &PwmBeep::turnOn_and_setOffTimer), repeat_offtime);
        }
    }
