#include "mbed.h"
#include "ATP301x_SPI.h"

//ATP301x_SPIライブラリのデモプログラムです。青mbed用です。
//ATP3011/ATP3012の音声記号や配線についてはATP3011/ATP3012製品サイトのデータシートをご覧ください。
//製品サイト：https://www.a-quest.com/products/aquestalkpicolsi.html

//ssはDigitalOutを使用します。
ATP301x_SPI ATP301x(p11, p12, p13, p14); //mosi,miso,sck,ss

int main() {
    while(1) {
        //chimeX()のisWait引数をtrueに指定すると、チャイム再生終了までwait()します。
        ATP301x.chimeJ(true);
        
        //talk()のisWait引数をtrueに指定すると、発話終了までwait()します。
        //音声合成「ATP301x音声合成LSI」
        ATP301x.talk("<ALPHA VAL=ATP301x>onnse-go'-se-eruesua'i.",true);
        
        //chimeX()やtalk()はデフォルトでisWait=trueになっています。
        ATP301x.chimeK();
        
        //chimeX()やtalk()はのisWait引数をfalseに指定すると、音声コマンド送信完了次第talk()を抜けます。
        //ここでは、次行のwait()経過後ループが先頭に戻ったタイミングで中断され、chimeJが鳴ります。
        //音声合成「中断されます」ループ
        ATP301x.talk("chu-dannsarema'_su/chu-dannsarema'_su/chu-dannsarema'_su.",false);
        wait(1.2);
        
        //長すぎ強制終了発動パターン（運よくキリの良いところで送信強制終了されて読まれるパターン）
        ATP301x.talk("nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su/nagasugima'_su");
    }
}
