/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "USBSerial.h"
#include "GPS/MAXM8.h"

#include "stdbool.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"



// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500


int main()
{   
    USBSerial serial;
    Serial gps(P0_23,P0_20,9600);
    
    char buffer[MAX_BUFFER_SIZE];
    bool result;
    char c;
    struct minmea_sentence nmeaStruct;
    int *isPositionDataValid;
    result=FALSE;
    
    
    

    while(result==FALSE){
            if(gps.readable()){
            serial.putc(gps.getc());
            //MAXM8_NMEA_Putc(gps.getc(),buffer);
            }
    }
    serial.printf("%s",buffer);
    
    MAXM8_NMEA_Parser(&nmeaStruct,isPositionDataValid,buffer);
   
    serial.printf("Latitude Integer: %ld",nmeaStruct.latitude.integer);
    
    while(1);
}


void Init (){
    serial.printf("Init_State");
    
