#include "mbed.h"
#include "MAXM8.h"
#define NUM_OF_NMEA_SENTENCES 3
// <editor-fold defaultstate="collapsed" desc="Golbal Variables"> 
 
int BUFFER_Num=0;
bool Status_SentenceIsReadyToParse;
bool Status_SentenceParsed;
 

// </editor-fold>
 
// <editor-fold defaultstate="collapsed" desc="Prototypes"> 
 
enum minmea_sentence_id MAXM8_NMEA_Id(char *str_id);

 
// </editor-fold>
  
char uart_first_buffer[MAX_BUFFER_SIZE];

 

bool MAXM8_NMEA_Putc(char uart_char, char *uart_buffer){

    static int sentence_initialized = FALSE;
    static char *uart_buffer_prt=0;

    if (uart_char == '$') {
        uart_buffer_prt=uart_buffer;
        memset(uart_buffer_prt, '\0', MAX_BUFFER_SIZE); //clears the buffer
        *uart_buffer_prt = uart_char;
        uart_buffer_prt++;
        sentence_initialized = TRUE;
        
        return FALSE;//Sentence Not Complete

    } else if (uart_char != '\r' && sentence_initialized == TRUE) {
        *uart_buffer_prt = uart_char;
        uart_buffer_prt++;
        
        return FALSE; //Sentence Not Complete

    } else if (uart_char == '\r' && sentence_initialized == TRUE) {
        *uart_buffer_prt = '\0';
        sentence_initialized = FALSE;
        
        return TRUE; //Sentence Complete
    }
    else
        return FALSE;
}
 
bool MAXM8_NMEA_Parser(struct minmea_sentence *gps_frame, int *isPositionDataValid, char *uart_buffer_prt) {


    //GGA - RMC - VTG
    char *start_decimalpart;
    char *end_decimalpart;
    int  GPS_nmea_id;
    char *field[MAX_FIELDS_NUMBER];

    bool isSentenceParsedValid=FALSE;

    int p = 0;

    // <editor-fold defaultstate="collapsed" desc="Command Splitter">
    field[0] =(uart_buffer_prt);

    while (*uart_buffer_prt != '\0') {
        if (*uart_buffer_prt == ',' || *uart_buffer_prt == '*') {
            *uart_buffer_prt = '\0';
            field[++p] = uart_buffer_prt + 1;
        }
        uart_buffer_prt++;
    }


    // </editor-fold>

    // <editor-fold defaultstate="collapsed" desc="Parser">


    GPS_nmea_id = MAXM8_NMEA_Id(field[0]);



    switch (GPS_nmea_id) {

        case NMEA_SENTENCE_RMC:
            //$GPRMC,130652.000,A,4038.0868,N,00838.9093,W,0.40,67.63,290316,,,A*49
            //Valid
             //FGPMMOPA6H_DisableInterrupts();



            if (*field[2]== 'A'){ //If the coordenates are valid


        //Latitude

                gps_frame->latitude.integer = strtol(field[3], &start_decimalpart, 10);


                //printf("%ld ",gps_frame->latitude.integer);


                gps_frame->latitude.decimal = strtol(start_decimalpart+1, &end_decimalpart, 10);
                if (strcmp(field[4], "N") == 0)
                    gps_frame->latitude.cardeal = 0; //0=North

                if (strcmp(field[4], "S") == 0)
                    gps_frame->latitude.cardeal = 1; // 1=South



                //Longitude
                gps_frame->longitude.integer = strtol(field[5], &start_decimalpart, 10);
                gps_frame->longitude.decimal = strtol(start_decimalpart+1, &end_decimalpart, 10);

                //Longitude
                if (strcmp(field[6], "W") == 0)
                    gps_frame->longitude.cardeal = 0; //0=West

                if (strcmp(field[6], "E") == 0)
                    gps_frame->longitude.cardeal = 1; // 1=East
            }
            else
                *isPositionDataValid = FALSE;

            break;

      case NMEA_SENTENCE_GGA:
                isSentenceParsedValid=TRUE;
            gps_frame->altitude = strtol(field[11], &start_decimalpart, 10);

            gps_frame->num_of_satellites_tracked= strtol(field[7],&start_decimalpart, 10);

            break;

        case NMEA_SENTENCE_VTG:
                isSentenceParsedValid=TRUE;

            gps_frame->speed = strtol(field[7], &start_decimalpart, 10);
            break;

        default:
            isSentenceParsedValid=FALSE;
            break;
    }



    return isSentenceParsedValid;
}
 
enum minmea_sentence_id MAXM8_NMEA_Id(char *str_id) {
 
    if (strcmp(str_id, "$GPGGA") == 0)
        return NMEA_SENTENCE_GGA;
    else if (strcmp(str_id, "$GPRMC") == 0)
        return NMEA_SENTENCE_RMC;
     
    else if (strcmp(str_id,"$GPVTG")==0)
        return NMEA_SENTENCE_VTG;
 
    else
        return MINMEA_UNKNOWN;
 
     
}
 