#ifndef MAXM8_H_INCLUDED
#define MAXM8_H_INCLUDED
#include <stdbool.h>

#define MAX_BUFFER_SIZE 90
#define MAX_FIELDS_NUMBER 25
#define FALSE 0
#define TRUE  1
#define UNDEFINED 3
 
 
enum minmea_sentence_id {
    MINMEA_INVALID = -1,
    MINMEA_UNKNOWN = 0,
    NMEA_SENTENCE_RMC,
    NMEA_SENTENCE_GGA,
    NMEA_SENTENCE_VTG,
};
 
struct minmea_coord {
    long integer;
    long decimal;
    uint8_t cardeal;
};
 
struct minmea_date {
    int day;
    int month;
    int year;
};
 
struct minmea_time {
    int hours;
    int minutes;
    int seconds;
    int microseconds;
};
 
struct minmea_sentence {
    struct minmea_time time;
    struct minmea_coord latitude;
    struct minmea_coord longitude;
    struct minmea_date date;
     
    bool valid;
    int altitude;
    int speed;
    int fix_quality;
    int num_of_satellites_tracked;
 
};

bool MAXM8_NMEA_Putc(char uart_char, char *uart_buffer_prt);
bool MAXM8_NMEA_Parser(struct minmea_sentence *gps_frame,int *isPositionDataValid,char *uart_buffer_prt);

#endif // MAXM8_H_INCLUDED