#include "mbed.h"

#include "EthernetNetIf.h"
#include "HTTPClient.h"

#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

EthernetNetIf eth;
HTTPClient http;

HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

void parseWeather(SP_XmlElementNode *node) {
    SP_XmlHandle handle(node);
    SP_XmlElementNode * tempc = handle.getChild( "temp_c" ).toElement();
    if (tempc) {
        printf("current temp=%sC\n",tempc->getAttrValue("data"));
    }
    SP_XmlElementNode * tempf = handle.getChild( "temp_f" ).toElement();
    if (tempf) {
        printf("current temp=%sF\n",tempf->getAttrValue("data"));
    }
}

int main() {
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers

    printf("setup\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error in setup\n");
        return -1;
    }
    printf("setup ok\n");

    SP_XmlDomParser parser;

    HTTPStream stream;

    char BigBuf[512 + 1] = {0};
    stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read

    HTTPResult r = http.get("http://www.google.com/ig/api?weather=Los+Angeles", &stream, request_callback);

    while (!completed) {
        Net::poll(); //Polls the Networking stack
        if (stream.readable()) {
            BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
            
            parser.append( BigBuf, strlen(BigBuf)); // stream current buffer data to the XML parser
            
            stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
        }
    }
    if (result == HTTP_OK) {
        printf("Read completely\n");
    } else {
        printf("Error %d\n", result);
        return -1;
    }

    SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
    SP_XmlElementNode * child2 = rootHandle.getChild( "weather" )
                                 .getChild( "current_conditions").toElement();

    if ( child2 ) {
        parseWeather(child2);
    }

    if ( NULL != parser.getError() ) {
        printf( "\n\nerror: %s\n", parser.getError() );
    }

    printf("end\n");

}
