#include "EthernetNetIf.h"

#include "mbed.h"

#include "pop3.h"

main()
{
    EthernetNetIf eth;
    EthernetErr ethErr;
    printf("Setting up...\n");
    do {
        ethErr = eth.setup();
        if (ethErr) printf("waiting for network...\n", ethErr);
    } while (ethErr != ETH_OK);

    Pop3 *p3=new Pop3("mail.server","mail.user","mail.password");
    
    bool r=p3->init();
    
    printf("init ok=%i\n",r);
    
    if(r)
    {
        list<string> *ids=p3->getMessages();
        list<string>::iterator it;
        for ( it=ids->begin() ; it != ids->end(); it++ )
        {
            printf("id=%s\n",(*it).c_str());
            
            Pop3Message *msg=p3->getMessage(*it);
            if (NULL==msg)
                continue;
            printf("from %s\n",msg->from.c_str());
            printf("subj %s\n",msg->subject.c_str());
            
            p3->deleteMessage(*it);
            
            delete msg;
            
        }
        delete ids;
    }
    p3->close();
    delete p3;
}