#include "mbed.h"

#include "EthernetNetIf.h"
#include "NTPClient.h"

#include "AvailableMemory.h"

LocalFileSystem local("local");

void updateTime()
{
    time_t ctTime;
    time(&ctTime);
    printf("Current time is (UTC): %s\n", ctime(&ctTime));

    NTPClient ntp;
    Host server(IpAddr(), 123, "de.pool.ntp.org");
    ntp.setTime(server);
    
    printf("set time ok\n");
    time(&ctTime);
    printf("Current time is (UTC): %s\n", ctime(&ctTime));
   
}

int main() {
    printf("******** [%s] *********\n",__TIME__);
    printf("calculate free mem 1\n");
    int i=AvailableMemory(1,0x8000,false);
    printf("free mem=%i\n",i);

//    void* p1=malloc(8000);
//    void* p2=malloc(8000);

    printf("setup\n");
    EthernetNetIf eth;
    EthernetErr ethErr;
    printf("Setting up network...\n");
    do {
        ethErr = eth.setup();
        if (ethErr) printf("waiting for network...\n", ethErr);
    } while (ethErr != ETH_OK);

    printf("setup ok\n");

    updateTime();

//    free(p1);
//    free(p2);
    printf("calculate free mem 4\n");
    i=AvailableMemory(1,0x100,false);
    printf("free mem=%i\n",i);
    i=AvailableMemory(1,0x8000,false);
    printf("free mem=%i\n",i);
}
