#ifndef STRINGREADER_H
#define STRINGREADER_H

#include <stdlib.h>
#include <string.h>

class CStringReadCallBack : public IFileReadCallBack
{
public:

	//! construct from filename
	CStringReadCallBack(char* data)
		: Size(0), Close(true), _offset(0)
	{
    	_data=data;
    	Size=strlen(_data);
	}

	//! destructor
	virtual ~CStringReadCallBack()
	{
	}

	//! Reads an amount of bytes from the file.
	virtual int read(void* buffer, int sizeToRead)
	{
	    int len=sizeToRead;
	    if (Size-_offset>len)
	        len=Size-_offset;
        memcpy(buffer,_data+_offset,len);
		return len;
	}

	//! Returns size of file in bytes
	virtual int getSize()
	{
		return Size;
	}

private:

	int Size;
	int _offset;
	bool Close;
	char* _data;

}; // end class CFileReadCallBack

#endif
