/*
* mbed AR1020 library
* Copyright (c) 2010 Hendrik Lipka
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __TOUCHPANEL_H_
#define __TOUCHPANEL_H_

#include "FPointer.h"

class TouchPanel
 {
    public:
        /**
            initialize the controller
        */
        virtual void init()=0;
        
        /**
            read X coordinate (from last update)
            @returns last known X coordinate
        */
        virtual int x()=0;
        /**
            read Y coordinate (from last update)
            @returns last known Y coordinate
        */
        virtual int y()=0;
        
        /**
            @return 0 if pen is up, >0 if pen is down (maybe different due to touch pressure, if supported)
        */
        virtual int pen()=0;
        
        /**
            read coordinates on request
        */
        virtual void read()=0;
        
        class T;
        
        /**
            attach listener called on 'pen-down'
            @params item the callback object
            @params method the callback method
        */
        template<class T> 
        void attachPenDown(T* item, uint32_t (T::*method)(uint32_t)) { _callbackPD.attach(item, method); }   
        /**
            attach listener called on 'pen-down'
            @params function the callback function
        */
        void attachPenDown(uint32_t (*function)(uint32_t)) { _callbackPD.attach(function); }   
        /**
            attach listener called on 'pen-move'
            @params item the callback object
            @params method the callback method
        */
        template<class T> 
        void attachPenMove(T* item, uint32_t (T::*method)(uint32_t)) { _callbackPM.attach(item, method); }   
        /**
            attach listener called on 'pen-move'
            @params function the callback function
        */
        void attachPenMove(uint32_t (*function)(uint32_t)) { _callbackPM.attach(function); }   
        /**
            attach listener called on 'pen-up'
            @params item the callback object
            @params method the callback method
        */
        template<class T> 
        void attachPenUp(T* item, uint32_t (T::*method)(uint32_t)) { _callbackPU.attach(item, method); }   
        /**
            attach listener called on 'pen-up'
            @params function the callback function
        */
        void attachPenUp(uint32_t (*function)(uint32_t)) { _callbackPU.attach(function); }   
        
    protected:
        FPointer      _callbackPD;
        FPointer      _callbackPM;
        FPointer      _callbackPU;
 };


#endif