/*
* mbed AR1020 library
* Copyright (c) 2010 Hendrik Lipka
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __AREATOUCHHANDLER_H__
#define __AREATOUCHHANDLER_H__

#include "mbed.h"
#include "FPointer.h"
#include "touchpanel.h"
#include <list>

class area;

/**
    this class registers itself with a touch screen controller, and listens for touch events. 
    If an event matches a prefined region, the callback function is called with the corresponding command code.
*/
class AreaTouchHandler
{
    public:
        /**
            creates the handler, and attaches it to the given touch panel
            @params pane the touch panel to listen to
        */
        AreaTouchHandler(TouchPanel* panel);
        /**
            set the callback method        
            @params item the callback object
            @params method the callback method
        */
        class T;
        template<class T> 
        void attach(T* item, uint32_t (T::*method)(uint32_t)) { _callback.attach(item, method); }   
        /**
            set the callback method        
            @params function the callback function
        */
        void attach(uint32_t (*function)(uint32_t)) { _callback.attach(function); }   

        /**
            defines the command for a specific region
            @params top the top of the region (y)
            @params bottom the bottom of the region (y)
            @params the left side of the region (x)
            @params the right side of the region (x)
            @params the command code for this region
        */        
        void addArea(int top, int bottom, int left, int right, int commandCode);
    private:
        FPointer      _callback;
        std::list<area*> _areas;
        uint32_t down(uint32_t arg);
        uint32_t move(uint32_t arg);
        uint32_t up(uint32_t arg);
        
        int findCommand();
        
        float _x, _y;
        int _samples;
        bool _called;
};


#endif
