/*
* mbed AR1020 library
* Copyright (c) 2010 Hendrik Lipka
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "AreaTouchHandler.h"
#include "touchevent.h"

using namespace std;

class area
{
    public:
    int top,bottom,left,right,command;
    area(int top, int bottom, int left, int right, int command)
    {
        this->top=top;
        this->bottom=bottom;
        this->left=left;
        this->right=right;
        this->command=command;
    }
};

AreaTouchHandler::AreaTouchHandler(TouchPanel* panel)
{
    panel->attachPenDown(this,&AreaTouchHandler::down);
    panel->attachPenMove(this,&AreaTouchHandler::move);
    panel->attachPenUp(this,&AreaTouchHandler::up);
}

void AreaTouchHandler::addArea(int top, int bottom, int left, int right, int commandCode)
{
    _areas.push_back(new area(top,bottom,left,right,commandCode));
}

uint32_t AreaTouchHandler::down(uint32_t arg)
{
    TouchEvent *te=(TouchEvent*)arg;
//    printf("d %i/%i\n",te->x,te->y);
    _x=te->x;
    _y=te->y;
    _samples=1;
    int c=findCommand();
    _called=false;
    if (0!=c)
    {
        _called=true;
        _callback.call(c);
    }
    return 0;
}
uint32_t AreaTouchHandler::move(uint32_t arg)
{
    if (_called)
        return 0;
    TouchEvent *te=(TouchEvent*)arg;
//    printf("m %i/%i\n",te->x,te->y);
    _x=(te->x+_x*_samples)/(_samples+1);
    _y=(te->y+_y*_samples)/(_samples+1);
    _samples++;
    int c=findCommand();
    if (0!=c)
    {
        _called=true;
        _callback.call(c);
    }
    return 0;
}
uint32_t AreaTouchHandler::up(uint32_t arg)
{
    _x=0;
    _y=0;
    _samples=0;
    _called=false;
    return 0;
}

int AreaTouchHandler::findCommand()
{
    if (_called)
        return 0;
    if (_samples<5)
        return 0;
    for (list<area*>::iterator it = _areas.begin(); it != _areas.end(); it++) {
        area* a=*it;
        if (_x>=a->left && _x<=a->right && _y>=a->top && _y<=a->bottom)
            return a->command;
        }
    return 0;
}
