#include "mbed.h"

#include "EthernetNetIf.h"
#include "NTPClient.h"

#include "Time.h"

LocalFileSystem local("local");

void updateTime()
{
    time_t ctTime;
    time(&ctTime);
    printf("Current time is (UTC): %s\n", ctime(&ctTime));

    NTPClient ntp;
    Host server(IpAddr(), 123, "0.de.pool.ntp.org");
    ntp.setTime(server);

  printf("set time ok\n");
  time(&ctTime);
  printf("Current time is (UTC): %s\n", ctime(&ctTime));
    
}

int main() {
    void* p1=malloc(16000); // to ensure we have enough heap after NTP setup

    printf("setup\n");
    EthernetNetIf eth;
    EthernetErr ethErr;
    printf("Setting up...\n");
    do {
        ethErr = eth.setup();
        if (ethErr) printf("waiting for network...\n", ethErr);
    } while (ethErr != ETH_OK);

    printf("setup ok\n");

    updateTime();
    
    free(p1); // reclaim back memory

    char *buf=new char[32];

    Time *time=new Time();
    TimeStamp *timestamp=time->getTime();

    snprintf(buf,32,"%.2d/%.2d %.2d:%.2d:%.2d",
        timestamp->getMonth()+1, timestamp->getDay(), 
        timestamp->getHour(), timestamp->getMinute(), timestamp->getSecond());
    printf("time=%s\n",buf);

    delete [] buf;
    delete timestamp;
    delete time;

}
