/*
* TcpLineStream library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __TCPLINESTREAM__H__
#define __TCPLINESTREAM__H__

#include "TCPSocket.h"
#include "string"

#define BUFSIZE 1024

using namespace std;

class TCPLineStream
{
    public:
        TCPLineStream(const char *host, int port, const char* _term="\r\n");
        ~TCPLineStream(){close();};
        bool open();
        void close();
        
        string readLine(int strLen=64);
        void sendLine(string line);
        
    private:
        void init();
        void onTCPSocketEvent(TCPSocketEvent e);
        
        const char *_server;
        int _port;
        
        bool _connecting;
        bool _connected;
        bool _closed;
        TCPSocket *_socket;

        char _readbuf[BUFSIZE];
        int _readpos;
        int _readlen;
        
        const char* _term;
};

#endif