/*
* WebService library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __WEBSERVICE_H__
#define __WEBSERVICE_H__

#include "spdomparser.hpp"

#include "url.h"

#include "tcplinestream.h"

/**
A simple web service over HTTP library. Calls a HTTP server via GET, and returns the response wrapped in a XML parser. All calls are synchronous.
Needs the NetServicesMin and DNSResolver library
The code for URL handling has been copied directly from the original NetServices library (Thanks to Donatien!).

*/
class WebService
{
    public:
        /**
            create the web service instance.
            @params urlStr the URL to call via GET
        */
        WebService(const char* urlStr);
        /**
            Execute the web service call. Note that the caller is responsible for freeing the return parser instance.
            @return the XML parser, or NULL if an error occured
        */
        SP_XmlDomParser *callService();
        /**
            close all resources
        */
        ~WebService(){close();};
        /**
            close all resources
        */
        void close();
        
    private:
        void init();
        
        string _request;
        
        TCPLineStream *_stream;
};



#endif