/*
* WebService library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "Timer.h"

#include "webservice.h"

#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

WebService::WebService(const char* urlStr) {
    Url *url=new Url();
    url->fromString(urlStr);
    
//    printf("host name from URL=%s\n",url->getHost().c_str());

    _stream=new TCPLineStream(url->getHost().c_str(),0==url->getPort()?80:url->getPort(),"\r\n");
    delete url;

    _request=string("GET ").append(urlStr).append(" HTTP/1.0\r\n");
//    printf("request=[%s]\n",_request.c_str());
}

SP_XmlDomParser* WebService::callService() {
    if (!_stream->open())
        return NULL;

//    printf("send request[%s]\n",request.c_str());
    _stream->sendLine(_request);

    string firstLine=_stream->readLine();
    // todo: parse for HTTP response
    // response must be for HTTP/1.0, and be 200
    if (0!=firstLine.compare("HTTP/1.0 200 OK")) {
        printf("call not sucessfull, response=%s\n",firstLine.c_str());
        return NULL;
    }
    // skip headers
    while (true) {
        string line=_stream->readLine();
//        printf("header=[%s]\n",line.c_str());
        if (0==line.length())
            break;
    }
    SP_XmlDomParser *parser=new SP_XmlDomParser();
    while (true) {
        string line=_stream->readLine(1500);
//        printf("content=[%s]\n",line.c_str());
        parser->append(line.c_str(),line.length());
        if (0==line.length())
            break;
    }
    _stream->close();
    return parser;
}

void WebService::close() {
    if (NULL!=_stream) {
        _stream->close();
        delete _stream;
        _stream=NULL;
    }
}

