#include "mbed.h"

#include "Ser25lcxxx.h"

void dumpLine(char* s, int len)
{
    for (int i=0;i<len;i++)
    {
        printf("%X ",s[i]);
    }
    printf("\n");
}

void dump(char *s, int len)
{
    int i=0;
    while (i<len)
    {
        if (i+16<len)
            dumpLine(s+i,16);
        else
            dumpLine(s+i,len-i);
        i+=16;
    }
}

int main() {
    printf("******** [%s] *********\n",__TIME__);
    // setup hardware
    SPI spi(p5,p6,p7);
    spi.format(8,3);
    spi.frequency(1000000);
    // /CS is connected to p9, chip,in question is a 25LC256 (32kx8, 64-byte page)
    Ser25LCxxx flash(&spi, p9, 32768,64);
    
    int len=128;
    
    // dump initial memory content (first 2 pages)
    char* r=flash.read(0,len);
    dump(r,len);
    printf("\n");
    
    // write some stuff to the first and second page
    char buf[64];
    sprintf(buf,"******** [%s] *********\n",__TIME__);
    
    bool b=flash.write(50,strlen(buf),buf);

    // read written data back (first 2 pages)
    r=flash.read(0,len);
    dump(r,len);
    printf("\n");
    
    // clear first page, read first 2 pages back
    flash.clearPage(0);
    r=flash.read(0,len);
    dump(r,len);
    printf("\n");
    
    // clear everything, read first 2 pages back
    flash.clearMem();
    r=flash.read(0,len);
    dump(r,len);
    printf("\n");
    
}
