#include "mbed.h"

#include "math.h"

/*
    read the light value from a photo transistor connected to P20 and
    drive a LCDs LED backlight connected to P25.
    The backlight should dimm in the dark and brighten up when the lights go on.
    
    NOTE: the version below doesn't work, remove the printf in line 35!
*/
int main() {
    DigitalOut led1(LED1);
    float f=0.0;
    PwmOut display(p25);
    display.period_ms(1);
    display=f;
    
    AnalogIn light(p20);
   
    for (int i=0;i<100;i++)
    {
        f=f+0.01;
        display=f;
        wait (0.03);
    }
    printf("%f\n",display.read());
    led1=1;
        
    while (true)
    {
        double d=light;
        double sq=pow(d,0.6);
        display.write(sq*3);
        printf("%f / %f\n",d,sq);
        wait(1);
    }
}
