/*
* Localization library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "Localization.h"
#include "csv_parser.h"

using namespace std;

Localization::Localization() {
    const char * filename = "/local/loc.csv";

    const char field_terminator = '=';
    const char line_terminator  = '\n';
    const char enclosure_char   = '"';
    
    _entries=new list<MsgEntry*>();

    csv_parser file_parser;//=new csv_parser();;

    /* Define how many records we're gonna skip. This could be used to skip the column definitions. */
    file_parser.set_skip_lines(0);

    /* Specify the file to parse */
    file_parser.init(filename);

    /* Here we tell the parser how to parse the file */
    file_parser.set_enclosed_char(enclosure_char, ENCLOSURE_OPTIONAL);

    file_parser.set_field_term_char(field_terminator);

    file_parser.set_line_term_char(line_terminator);

    /* Check to see if there are more records, then grab each row one at a time */
    while (file_parser.has_more_rows()) {
        csv_row row = file_parser.get_row();
        if (row.size()<2) {
//            printf("row too short\n");
            continue;
        }
        MsgEntry* me=new MsgEntry(); 
        me->key=new char[row[0].size()+1];
        strcpy(me->key,row[0].c_str());
        
        me->text=new char[row[1].size()+1];
        strcpy(me->text,row[1].c_str());
        
        _entries->push_back(me);
    }
}

const char* Localization::getLocalizedValue(const char* id) {
    if (NULL==id)
        return NULL;
    for (list<MsgEntry*>::iterator it = _entries->begin(); it != _entries->end(); it++) {
        MsgEntry* me=*it;
        if (0==strcmp(me->key,id))
            return me->text;
    }

    return NULL;
}
