#include "mbed.h"
 
#include "dogm_spi.h"
 
#include "hd44780_8bit.h"
 
#include "subwindow.h"
 
#include "teewindow.h"
 
#include "terminal.h"
 
#include "multiwindow.h"
 
int main( void ) {
 
    // create an instance for the HD44780 display (2 lines, 16 chars)
 
    BusOut *data=new BusOut(p21,p22,p23,p24,p25,p26,p27,p28);
 
    HD44780LCD8bit* lcd1=new HD44780LCD8bit(16,2,data, p20, p19);
 
    lcd1->init();
 
    // and write the usual hello world
 
    lcd1->writeText(0,0,"hello");
 
    lcd1->writeText(1,4,"world");
 
    // create a LCD instance for the dogm162 display
 
    DogmLCDSPI* lcd2=new DogmLCDSPI(
 
        16, // width
 
        2,  // height
 
        new SPI(p5, NC, p7), // dataOut, no dataIn, clock
 
        p9, // enable
 
        p8  // RS
 
    );
 
    lcd2->init();
 
    // and write the german hello world
 
    lcd2->writeText(0,0,"hallo");
 
    lcd2->writeText(1,4,"welt!");
 
    // create a sub window on each display, spanning the right half of the displays
 
    SubWindow *w1=new SubWindow(lcd1,8,0,8,2);
 
    SubWindow *w2=new SubWindow(lcd2,8,0,8,2);
 
    // create avector of all sub windows, for later use
 
    vector<Window*> lcds;
 
    lcds.push_back(w1);
 
    lcds.push_back(w2);
 
 
    // the tee window will write to both sub windows at once
 
    Window* tw=new TeeWindow(lcds);
 
 
    // so write to both display at the same time
 
    tw->writeText(0,0,"00");
 
    tw->writeText(1,1,"11");
 
    wait(1);
 
 
    // create a terminal which also is dulicated to both displays
 
    // write some text to it and scroll
 
    Terminal t(tw);
 
    t.clear();
 
    t.writeText(0,0,"1234");
 
    t.writeText(1,1,"abcd");
 
    wait(1);
 
    t.addText("Hello");
 
    wait(1);
 
    t.addText("World");
 
    wait(1);
 
    t.addText("and");
 
    wait(1);
 
    t.addText("even");
 
    wait(1);
 
    t.addText("some");
 
    wait(1);
 
    t.addText("more");
 
    // create 2 subwindows for the left half of both displays
 
    SubWindow *w3=new SubWindow(lcd1,0,0,8,2);
 
    SubWindow *w4=new SubWindow(lcd2,0,0,8,2);
 
    vector<Window*> lcds2;
 
    lcds2.push_back(w3);
 
    lcds2.push_back(w4);
 
    // create a window spanning both sub windows (and therefore both display)
 
    MultiWindow* mw=new MultiWindow(lcds2);
 
    // and a terminal on it - which means it scrolls across both displays
 
    Terminal t2(mw);
 
    t2.clear();
 
    t2.writeText(0,0,"1234");
 
    t2.writeText(1,1,"abcd");
 
    wait(1);
 
    t2.addText("Hello");
 
    wait(1);
 
    t2.addText("World");
 
    wait(1);
 
    t2.addText("and");
 
    wait(1);
 
    t2.addText("even");
 
    wait(1);
 
    t2.addText("some");
 
    wait(1);
 
    t2.addText("more");
 
}