#include "mbed.h"
#include "HTTPClient.h"
#include "EthernetNetIf.h"

DigitalOut led(LED1);

EthernetNetIf eth;

               
LocalFileSystem local("local");
/**
 * Request a google search for HelloWorld and display the first 2000 characters 
 * of the page source on the serial terminal.
 */
int main(void) {
EthernetNetIf eth(        // Brings up the device with static IP address and domain name.
                IpAddr(192,168,0,123),   // IPv4 address
                IpAddr(255,255,255,0),   // netmask
                IpAddr(192,168,0,1),     // default gateway
                IpAddr(192,168,0,1));    // dns server
  int ethErr = eth.setup();        // Brings up the device with static IP address and domain name.
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }

  HTTPClient http;
  HTTPText txt;
  
  HTTPResult r = http.get("http://mbed.org/media/uploads/donatien/hello.txt", &txt);
  if(r==HTTP_OK)
  {
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    printf("Error %d\n", r);
  }
  
  // Work is done!
  while(1) {
    led = !led;
    wait(0.2);
  }
}
