/*
 * mbed ASyncTicker library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/


#include "ASyncTicker.h"

class TickerEntry
{
    public:
        Timer timer;
        Updateable *target;
        int period;
};

ASyncTicker::ASyncTicker()
{
}

void ASyncTicker::addTarget(Updateable *target, int period)
{
    TickerEntry *te=new TickerEntry();
    te->target=target;
    te->period=period;
    _entries.push_back(te);
}

void ASyncTicker::run()
{
    list<TickerEntry*>::iterator it;
    for (it=_entries.begin();it!=_entries.end();it++)
    {
        TickerEntry *te=*it;
        te->timer.reset();
        te->timer.start();
    }
    while (true)
    {
        list<TickerEntry*>::iterator it;
        for (it=_entries.begin();it!=_entries.end();it++)
        {
            TickerEntry *te=*it;
            if (te->timer.read()>te->period)
            {
                te->target->update();
                te->timer.reset();
            }
        }
        wait(1);
    }
}

