/*
 * mbed ASyncTicker library
* Copyright (c) 2010 Hendrik Lipka
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef __ASYNC_TICKER_H__
#define __ASYNC_TICKER_H__

#include "Updateable.h"
#include <list>
#include "mbed.h"

using namespace std;

class TickerEntry;

/**
    an asynchronous ticker which allows calling methods in a regular fashion, but not from an interrupt handler.
    This allows for slower methods (e.g. printing to the serial console, doing network requests or complex 
    calculation), without affecting other parts of the application.
    
    Note that the run method of this class never returns!
    
    Since it is using the Timer class, the period between each call cannot be longer than approx. 30 minutes.
*/
class ASyncTicker
{
    public:
        ASyncTicker();
        /**
            add an object to be called
            @params target the target object whose 'update' method is called
            @params period the number of seconds between each call (not more then 30 minutes)
        */
        void addTarget(Updateable *target, int period);
        
        /**
            starts the ticker
            NOTW: this method never returns!
        */
        void run();
    private:
        list<TickerEntry*> _entries;
};


#endif
