#include "mbed.h"

#if defined(TARGET_LPC1768)
    //#include "C12832.h" //for LCD
    #include "LM75B.h" //for Temperature Sensor
#elif defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)
    //Sensor N/A for Nucleo
#elif defined(TARGET_WIZwiki_W7500)
    #include "DHT.h"
#endif

//DigitalOut myled(LED1);

#if defined(TARGET_LPC1768)
    //C12832 lcd(p5, p7, p6, p8, p11);
    LM75B sensor(p28, p27);
#elif defined(TARGET_WIZwiki_W7500)
    //PwmOut        r(LED_RED);
    //PwmOut        g(LED_GREEN);
    //PwmOut        b(LED_BLUE);
    DHT sensor(D4, DHT11);
    DigitalOut      r(LED_RED);
    DigitalOut      g(LED_GREEN);
    DigitalOut      b(LED_BLUE);
    //AnalogIn      ain0(A0);
    //AnalogIn      ain1(A1);
#endif


Serial pc(USBTX, USBRX);

/**
 * GMMP Test Code
 */

#include "GMMP.h"

#define USER_CONTROL_LED 0x80

#define HIGH 0x1
#define LOW  0x0


byte serverIp[] = {61, 250, 21, 211}; //ThingPlug GMMP
const int nServerPort = 31002; //ThingPlug GMMP
const char* pszDomainCode = "ThingPlug";
#if defined(TARGET_LPC1768)
//const char* pszGWAuthID = "0002F7F1CE5A";
//const char* pszGWMFID = "NXP";
//const char* pszDeviceMFID = "NXP";
// Eric's Device #2, APIKey = _b4u79jV2IZP9u9n6LU7WySz9Zw=
const char* pszGWAuthID = "0008DC1D69F3";
const char* pszGWMFID = "WIZnet";
const char* pszDeviceMFID = "WIZnet";
#elif defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)
const char* pszGWAuthID = "98F170674DC3";
const char* pszGWMFID = "STMicro";
const char* pszDeviceMFID = "STMicro";
#elif defined(TARGET_WIZwiki_W7500)
// Eric's Device #2, APIKey = _b4u79jV2IZP9u9n6LU7WySz9Zw=
const char* pszGWAuthID = "0008DC1D69F3";
const char* pszGWMFID = "WIZnet";
const char* pszDeviceMFID = "WIZnet";
#else
const char* pszGWAuthID = "0008DC1D69F3";
const char* pszGWMFID = "WIZnet";
const char* pszDeviceMFID = "WIZnet";
#endif
char* deviceId[LEN_DEVICE_ID];

#if defined(TARGET_LPC1768)
    //byte mac[] = {0x00, 0x02, 0xF7, 0xF1, 0xCE, 0x5A}; //mbed Application Board Ethernet
    byte mac[6] = {0x00,0x08,0xDC,0x1D,0x69,0xF3}; // WIZnet MAC address #2
#elif defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)
    //byte mac[] = {0x98, 0xF1, 0x70, 0x67, 0x4D, 0xC3}; //MURATA WIFI
    byte mac[6] = {0x00,0x08,0xDC,0x1D,0x6A,0x0B}; // WIZnet MAC address #1
#elif defined(TARGET_WIZwiki_W7500)
    byte mac[6] = {0x00,0x08,0xDC,0x1D,0x69,0xF3}; // WIZnet MAC address #2
#else
    byte mac[6] = {0x00, };
#endif

uint32_t lastDeliverMilli = 0;
uint32_t reportPeriodMilli = 3000;
uint32_t lastHeartbeatMilli = 0;
uint32_t heartbeatPeriodMilli = 10000;
byte regDevCount = 0;
byte regGwCount = 0;

void startSensingTemp();
void delay(int d);

int Recv(GMMPHeader* pstGMMPHeader, void* pBody)
{
  U8 cMessageType = pstGMMPHeader->ucMessageType;

  //info(F("MsgType: "));
  //infoln(cMessageType);
  INFO("MsgType: %d", cMessageType);

  if (cMessageType == OPERATION_GW_REG_RSP) {
    stGwRegistrationRspHdr* pstRspHdr = (stGwRegistrationRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      //error(F("GWRegRes Error: "));
      //errorln(pstRspHdr->ucResultCode);
      ERR("GWRegRes Error: %d", pstRspHdr->ucResultCode);
      free(pBody);
      return 1;
    }

    SetAuthKey((char*) pstGMMPHeader->usAuthKey);
    SetGWID((char*) pstRspHdr->usGWID);
    infoln(("GWRegRes has been received:"));
    infoln(g_szAuthKey);
    infoln(GetGWID());
    INFO("GWRegRes has been received:\r\n%s\r\n%s", g_szAuthKey, GetGWID());
    regGwCount++;

    int ret = GO_Profile(GetGWID(), NULL, 0);

    if (ret != GMMP_SUCCESS) {
      errorln("ReqProfile Err!!");
      free(pBody);
      return 1;
    }

    infoln("ProfileReq has been sent.");
  } else if (cMessageType == OPERATION_PROFILE_RSP) {
    stProfileRspHdr* pstRspHdr = (stProfileRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      errorln("ProfileRes Error!");
      free(pBody);
      return 1;
    }

    //infoln(F("ProfileRes has been received:"));
    //infoln(Char2int(pstRspHdr->unHeartbeatPeriod, 4));
    //infoln(Char2int(pstRspHdr->unReportOffset, 4));
    //infoln(Char2int(pstRspHdr->unReportPeriod, 4));
    //infoln(Char2int(pstRspHdr->unResponseTimeout, 4));
    INFO("ProfileRes has been received:\r\n%d\r\n%d\r\n%d\r\n%d",
    Char2int(pstRspHdr->unHeartbeatPeriod, 4),
    Char2int(pstRspHdr->unReportOffset, 4),
    Char2int(pstRspHdr->unReportPeriod, 4),
    Char2int(pstRspHdr->unResponseTimeout,4) );
    /* 주기값 재설정
       pstRspHdr->unHeartbeatPeriod;
       pstRspHdr->unReportOffset;
       pstRspHdr->unReportPeriod;
       pstRspHdr->unResponseTimeout;
     */

    reportPeriodMilli = Char2int(pstRspHdr->unReportPeriod, 4) * 1000 * 60;
    //reportPeriodMilli = Char2int(pstRspHdr->unReportPeriod, 4) * 300;
    heartbeatPeriodMilli = Char2int(pstRspHdr->unHeartbeatPeriod, 4) * 1000 * 60;

    long nHeartBeat = Char2int((char*) pstRspHdr->unHeartbeatPeriod, sizeof(pstGMMPHeader->usTID)); //수신받은 Heartbeat 주기 값을 확인.

    //Profile 요청 수신 값에 Heartbeat 주기 값으로 변경
    if (nHeartBeat > 0) {
      //nTimerSec = nHeartBeat;
    }

    int ret = GO_Reg(GetGWID(), pszDeviceMFID);

    if (ret != GMMP_SUCCESS) {
      errorln("DevRegReq Err!!");
      free(pBody);
      return 1;
    }

    infoln("DevRegReq has been sent.");
  } else if (cMessageType == OPERATION_DEVICE_REG_RSP) {
    stDeviceRegistrationRspHdr* pstRspHdr = (stDeviceRegistrationRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      errorln("DevRegRes Error!");
      free(pBody);
      return 1;
    }

    if (strlen((char*) pstRspHdr->usDeviceID) <= 0) {
      errorln("No DeviceID!");
      free(pBody);
      return 1;
    }

    int len = strlen((char*) pstRspHdr->usDeviceID);
    memset(deviceId, 0, LEN_DEVICE_ID);
    memcpy(deviceId, pstRspHdr->usDeviceID, len);
    infoln("DevRegRes has been received:");
    infoln((char*) deviceId);
    regDevCount++;

    //startSensingTemp();
  } else if (cMessageType == OPERATION_DELIVERY_RSP) {
    stPacketDeliveryRspHdr* pstRspHdr = (stPacketDeliveryRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
//      errorln("DeliverRes Err!!");
      ERR("DeliverRes Err(0x%2x)!!", pstRspHdr->ucResultCode); //lesmin
      free(pBody);
      return 1;
    }
    
    infoln("DeliveryRes has been received.");
  } else if (pstGMMPHeader->ucMessageType == OPERATION_HEARTBEAT_RSP) {
    //stHeartBeatMsgRspHdr* pstRspHdr = (stHeartBeatMsgRspHdr*) pBody;
    
    infoln("HeartbeatRes has been received.");
  } else if (cMessageType  == OPERATION_CONTROL_REQ) {
    stControlReqHdr* pstReqHdr = (stControlReqHdr*) pBody;

    infoln("ControlReq has been received.");

    char cResult = 0x00;

    int len = 0;
    if (pstReqHdr->usMessageBody) {
      len = strlen((char*) pstReqHdr->usMessageBody);
    }
    if (len > 0) {
      info("Control Msg Body: ");
      infoln((char*) pstReqHdr->usMessageBody);
    }

    long nTID = Char2int((char*) pstGMMPHeader->usTID, sizeof(pstGMMPHeader->usTID));

    //debug(F("Received TID: "));
    //debugln(nTID);
    DBG("Received TID: %d\r\n", nTID);

    int ret = GO_Control((char*) pstReqHdr->usGWID, (char*) pstReqHdr->usDeviceID, nTID,
     (char)pstReqHdr->ucControlType, cResult);

    if (ret != GMMP_SUCCESS) {
      errorln("ControRes Err!!");
      free(pBody);
      return 1;
    }

    infoln("ControlRes has been sent.");

    //infoln(pstReqHdr->ucControlType);
    INFO("%d\r\n", pstReqHdr->ucControlType);

    if (pstReqHdr->ucControlType != USER_CONTROL_LED) {
      ERR("Unknown Control Msg: %d\r\n", pstReqHdr->ucControlType);
      free(pBody);
      return 1;
    }

    if (pstReqHdr->usMessageBody[0] == '1') {
      //myled = 1;
      infoln("LED ON");
    } else if (pstReqHdr->usMessageBody[0] == '0') {
      //myled = 0;
      infoln("LED OFF");
    } else {
      errorln("Unknown Control Msg Body; it must be '1' or '0'.");
      free(pBody);
      return 1;
    }

    //delay(1000); //msec

    ret = GO_Notifi((char*) pstReqHdr->usGWID, (char*) pstReqHdr->usDeviceID,
        (char)pstReqHdr->ucControlType, cResult, (char*) pstReqHdr->usMessageBody, 0);

    if (ret != GMMP_SUCCESS) {
      ERR("NotiReq Err: %d\r\n", ret);
      free(pBody);
      return 1;
    }

    infoln("Control NotiReq has been sent.");
  } else if (cMessageType  == OPERATION_NOTIFICATION_RSP) {
    stNotificationRspHdr* pstRspHdr = (stNotificationRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      //error(F("NotiRes Err: "));
      //errorln(pstRspHdr->ucResultCode);
      ERR("NotiRes Err: %d\r\n", pstRspHdr->ucResultCode);
      free(pBody);
      return 1;
    }

    infoln("NotiRes has been received.");
  } else if (cMessageType == OPERATION_GW_DEREG_RSP) {
    stGwRegistrationRspHdr* pstRspHdr = (stGwRegistrationRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      //error(F("DeregGwRes Err: "));
      //errorln(pstRspHdr->ucResultCode);
      ERR("DeregGwRes Err: %d\r\n", pstRspHdr->ucResultCode);
      free(pBody);
      return 1;
    }

    if (strlen((char*) pstRspHdr->usGWID) <= 0) {
      errorln("No GW ID!!");
      free(pBody);
      return 1;
    }

    if (strlen((char*) pstGMMPHeader->usAuthKey) <= 0) {
      errorln("No Auth Key!!");
      free(pBody);
      return 1;
    }

    infoln("DeregGwRes has been received.");
  } else if (cMessageType == OPERATION_DEVICE_DEREG_RSP) {
    stDeviceRegistrationRspHdr* pstRspHdr = (stDeviceRegistrationRspHdr*) pBody;

    if (pstRspHdr->ucResultCode != 0x00) {
      //error(F("DeregDevRes Err: "));
      //errorln(pstRspHdr->ucResultCode);
      ERR("DeregDevRes Err: %d\r\n", pstRspHdr->ucResultCode);
      free(pBody);
      return 1;
    }

    if (strlen((char*) pstRspHdr->usDeviceID) <= 0) {
      errorln("No device ID!!");
      free(pBody);
      return 1;
    }

    infoln("DeregDevRes has been received.");
  }

  free(pBody);
  return 0;
}

byte isSensing = 0;

void startSensingTemp()
{
#if defined(TARGET_LPC1768)
    if (sensor.open()) {    
        printf("Sensing started!\r\n");
        isSensing = 1;
    }
    else
#elif defined(TARGET_WIZwiki_W7500)
    if(1)
    {
        printf("Sensing started!\r\n");
        isSensing = 1;  
    }
    else
#endif 
    {
        printf("Sensor not detected!\r\n");
        //isSensing = 0;
        isSensing = 1; //emulate sensor
    }
}

#define BUF_SIZE 10
GMMPHeader header;
void *pBody = NULL;
char sendBuf[BUF_SIZE];

//Timer t; //for Millis()
Timer t_main; //for Millis()

void setup(void) {
    t_main.start();

  infoln("Start setup()");

    startSensingTemp(); //lesmin

#if defined(TARGET_LPC1768)
    //char mac_addr[19];
    //mbed_mac_address((char *)mac); //Use mbed mac addres
    //snprintf(mac_addr, 19, "%02x:%02x:%02x:%02x:%02x:%02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    //printf("MAC: %s\n", mac_addr);
    INFO("WIZnet MAC: %02x:%02x:%02x:%02x:%02x:%02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
#elif defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)
    INFO("Nucleo MAC: %02x:%02x:%02x:%02x:%02x:%02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
#elif defined(TARGET_WIZwiki_W7500)
    INFO("WIZnet MAC: %02x:%02x:%02x:%02x:%02x:%02x", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
#endif

  if ( Initialize(serverIp, nServerPort, pszDomainCode, pszGWAuthID, mac) ) {
      infoln("Initialize failed!");
  }

  SetCallFunction(Recv);
  
  int ret = GO_Reg(NULL, pszGWMFID);

  if (ret != GMMP_SUCCESS) {
    errorln("RegReq Error!!");
    for(;;);
  }

  infoln("GW RegReq has been sent.");
}

int millis(void) {
    return t_main.read_ms();
}

float getTemperature(void) {
#if defined(TARGET_LPC1768)
    float Temp = sensor;

    //lcd.cls();
    //lcd.locate(0,3);
    //lcd.printf("Temp = %.3f\n", (float)Temp);

    wait(1.0);
    return Temp;
#elif defined(TARGET_WIZwiki_W7500)       
    float c = 0.0f;
    if(!sensor.readData())
    {
        c = sensor.ReadTemperature(CELCIUS);
    }
    return c;
#else
    return 33.3;
#endif
}

void delay(int d) {
    float delay_time = d/1000.0;
    wait(delay_time);
}

void loop(void)
{
  int ret = GetReadData(&header, &pBody);
  if (ret != E_WOULDBLOCK) {
    infoln("******** NOT E_WOULDBLOCK *********");
    //info(F("Free memory size: "));
    //infoln(freeRam());
  }

  //byte addr[8];
  float temperature;

  int curMilli = millis();
  byte mustDeliver = (curMilli - lastDeliverMilli) > reportPeriodMilli;
  byte mustHeartbeat = (curMilli - lastHeartbeatMilli) > heartbeatPeriodMilli;
 
  if (!isSensing) {
    printf("Sensor is off...\r\n");
    return;
  }

#if 1
  //int mustGwDereg = digitalRead(DEREGISTRATION_GW_SWITCH_PIN);
  int mustGwDereg = LOW; //lesmin

  if (mustGwDereg == HIGH && regGwCount > 0) {
    ret = GO_DeReg(GetGWID(), NULL);

    if (ret != GMMP_SUCCESS) {
      errorln("DeregGwReq Error!!");
      delay(1000);
      return;
    }

    regGwCount--;
    return;
  }

  //int mustDevDereg = digitalRead(DEREGISTRATION_DEVICE_SWITCH_PIN);
  int mustDevDereg = LOW;

  if (mustDevDereg == HIGH && regDevCount > 0) {
    ret = GO_DeReg(GetGWID(), (char*) deviceId);

    if (ret != GMMP_SUCCESS) {
      errorln("DeregDevReq Error!!");
      delay(1000);
      return;
    }

    regDevCount--;
    return;
  }

  if (mustHeartbeat) {
    DBG("lastHeartbeatMilli: %d\r\ncurMilli: %d\r\n", lastHeartbeatMilli, curMilli);

    ret = GO_HB(GetGWID());

    if (ret != GMMP_SUCCESS) {
      errorln("HeartbeatReq Error!!");
      return;
    }

    infoln("HeartbeatReq has been sent.");

    lastHeartbeatMilli = curMilli;
  }

  if (!mustDeliver) {
    return;
  }
#endif

  temperature = getTemperature();

  memset(sendBuf, 0, BUF_SIZE);

  sprintf(sendBuf, "%.1f", temperature);

  ret = GO_Delivery(GetGWID(), NULL, DELIVERY_COLLECT_DATA, 0x01, sendBuf);

  info("Sent Data: ");
  infoln(sendBuf);
  INFO("Sent Data: %s\r\n", sendBuf);

  if (ret != GMMP_SUCCESS) {
    errorln("DeliveryReq Error!!");
    return;
  }

  lastDeliverMilli = curMilli;
}

int main() {

    //Set serial port baudrate speed: 115200
    pc.baud(115200); 
    wait(1);
        
    // Initialize: SKT ThingPlug GMMP (Network init included)        
    setup();    
    wait(1);    
    pc.printf("ThingPlug: Initialize Done\r\n");      
        
    while(1)
    {        
        // Run: SKT ThingPlug GMMP stack handler
        loop();
     
        //User's Applications
        {
        
        }
    }
}
