
#if !defined(MQTTETHERNET_H)
#define MQTTETHERNET_H

#include "MQTTmbed.h"
#include "EthernetInterface.h"
#include "MQTTSocket.h"

// Use DHCP mode
// Note: Please fill up the mac_addr array using VALID MAC address
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x00, 0x99};

// Use Static IP
// Note: Please fill up the 'xx' field using VALID network information
//uint8_t mac_addr[6] = {xx, xx, xx, xx, xx, xx};
//const char * ip_addr = "xx.xx.xx.xx";
//const char * gw_addr = "xx.xx.xx.xx";
//const char * snmask = "xx.xx.xx.xx";

class MQTTEthernet : public MQTTSocket
{
public:    
    MQTTEthernet()
    {
        wait(1);
        this->createSocket();
        //eth.init(mac_addr, ip_addr, snmask, gw_addr);     // Use Static IP
        eth.init(mac_addr);                                 // Use DHCP
        eth.connect();
    }
    
    EthernetInterface& getEth()
    {
        return eth;
    }
    
    void reconnect()
    {
        eth.connect();  // nothing I've tried actually works to reconnect 
    } 
    
private:

    EthernetInterface eth;
    
};


#endif
