/**
 * @file GMMP_Operation.cpp
 * @date 2015/07/20
 * @version 0.0.1.0
 **/

/*
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <pthread.h>
#include <unistd.h>
#include <stdarg.h>
*/
#include <time.h>

#include "GMMP_Operation.h"

long g_nTID = 0;
int g_bLog = false;

int g_nErrorLevel = GMMP_ERROR_LEVEL_ERROR;


//GW/Device 등록/해지 Request
int GMMP_SetReg(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszManufactureID)
{
  debugln("GMMP_SetReg()");

	int nRet = GMMP_SUCCESS;

	if(pszGWID == NULL) {
		GwRegist_Req stRegist_Req;
		memset(&stRegist_Req, 0 ,sizeof(stRegist_Req));

		nRet = SetHeader((void*)&stRegist_Req, sizeof(stRegist_Req), 1,  1, OPERATION_GW_REG_REQ, pszAuthID, NULL);
		if(nRet != GMMP_SUCCESS) {
			return nRet;
		}

		memcpy(stRegist_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
		memcpy(stRegist_Req.body.usManufactureID, pszManufactureID, strlen(pszManufactureID));

		GMMP_Trace(&stRegist_Req.header, &stRegist_Req.body);

		nRet = GMMP_GW_Reg_Req((GwRegist_Req*)&stRegist_Req);

	}
	else
	{
    /*
		if(pszAuthKey == NULL || strlen(pszAuthKey) > LEN_AUTH_KEY || strlen(pszGWID) > LEN_GW_ID)
		{
			return LIB_PARAM_ERROR;
		}
    */

		DeviceRegist_Req stRegist_Req;

		memset(&stRegist_Req, 0 ,sizeof(stRegist_Req));

		nRet = SetHeader((void*)&stRegist_Req, sizeof(stRegist_Req), 1,  1, OPERATION_DEVICE_REG_REQ, pszAuthID, pszAuthKey);
		if(nRet != GMMP_SUCCESS)
		{
			return nRet;
		}

		memcpy(stRegist_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
		memcpy(stRegist_Req.body.usGWID, pszGWID, strlen(pszGWID));
		memcpy(stRegist_Req.body.usManufactureID, pszManufactureID, strlen(pszManufactureID));

		GMMP_Trace(&stRegist_Req.header, &stRegist_Req.body);

		nRet =  GMMP_Device_Reg_Req((DeviceRegist_Req*)&stRegist_Req);
	}

	return nRet;
}

int GMMP_SetDeReg(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID == NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nRet = GMMP_SUCCESS;

	if(pszDeviceID == NULL) //GW DeReg
	{
		GwDeRegist_Req stDeRegist_Req;
		memset(&stDeRegist_Req, 0 ,sizeof(stDeRegist_Req));

		nRet = SetHeader((void*)&stDeRegist_Req,  sizeof(stDeRegist_Req), 1, 1,  OPERATION_GW_DEREG_REQ, pszAuthID, pszAuthKey);
		if(nRet != GMMP_SUCCESS)
		{
			return nRet;
		}

		memcpy(stDeRegist_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
		memcpy(stDeRegist_Req.body.usGWID, pszGWID, strlen(pszGWID));

		GMMP_Trace(&stDeRegist_Req.header, &stDeRegist_Req.body);

		nRet  =  GMMP_GW_DeReg_Req((GwDeRegist_Req*)&stDeRegist_Req);
	}
	else
	{
		DeviceDeRegist_Req stDeviceDeRegist_Req;

		memset(&stDeviceDeRegist_Req, 0 ,sizeof(stDeviceDeRegist_Req));

		nRet = SetHeader((void*)&stDeviceDeRegist_Req, sizeof(stDeviceDeRegist_Req), 1,  1, OPERATION_DEVICE_DEREG_REQ, pszAuthID, pszAuthKey);
		if(nRet != GMMP_SUCCESS)
		{
			return nRet;
		}

		memcpy(stDeviceDeRegist_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
		memcpy(stDeviceDeRegist_Req.body.usGWID, pszGWID, strlen(pszGWID));
		memcpy(stDeviceDeRegist_Req.body.usDeviceID, pszDeviceID, strlen(pszDeviceID));

		GMMP_Trace(&stDeviceDeRegist_Req.header, &stDeviceDeRegist_Req.body);

		nRet =  GMMP_Device_DeReg_Req((DeviceDeRegist_Req*)&stDeviceDeRegist_Req);
	}

	return nRet;
}

//Profile Info Request
int GMMP_SetProfile(const char* pszAuthID, const char* pszAuthKey, const char* pszDomainCode, const char* pszGWID, const char* pszDeviceID)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID ==NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nRet = GMMP_SUCCESS;

	Profile_Req  stProfile_Req;

	memset(&stProfile_Req, 0 ,sizeof(stProfile_Req));

	nRet = SetHeader((void*)&stProfile_Req, sizeof(stProfile_Req), 1,  1, OPERATION_PROFILE_REQ, pszAuthID, pszAuthKey);
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(stProfile_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
	memcpy(stProfile_Req.body.usGWID, pszGWID, strlen(pszGWID));

	if(pszDeviceID != NULL) //Device 판단
	{
		if(strlen(pszDeviceID) > LEN_DEVICE_ID) //Device ID 길이 확인
		{
		}
		else
		{
			memcpy(stProfile_Req.body.usDeviceID, pszDeviceID, strlen(pszDeviceID));
		}
	}

	GMMP_Trace(&stProfile_Req.header, &stProfile_Req.body);

	nRet =  GMMP_Profile_Req(&stProfile_Req);

	return nRet;
}

//수집 데이터 보고  Request
int GMMP_SetDelivery(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID,
		const char cReportType,
		const char cMediaType,
		const char* pszMessageBody,
		const int nTotalCount,
		const int nCurrentCount)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID == NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID
			|| cReportType < 0x00
			|| cReportType > 0x04
			|| cMediaType < 0x01
			|| pszMessageBody == NULL
			|| strlen(pszMessageBody) > MAX_MSG_BODY)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nMessageBodyLen = strlen(pszMessageBody);

  //debug("msgBodyLen = ");
  //debugln(nMessageBodyLen);
  DBG("msgBodyLen = %d", nMessageBodyLen);

	int nRet = GMMP_SUCCESS;

	Delivery_Req stDelivery_Req;

  //debug(F("ReqSize = "));
  //debugln(sizeof(stDelivery_Req));
  DBG("ReqSize = %d", sizeof(stDelivery_Req));

	memset(&stDelivery_Req, 0, sizeof(stDelivery_Req));

	int PacketSize = sizeof(stDelivery_Req) - MAX_MSG_BODY + nMessageBodyLen ; //Message Body의 속성은 Optinal이다

//  debug(F("pacektSize = "));
//  debugln(PacketSize);
	DBG("packetSize = %d", PacketSize);

	nRet = SetHeader((void*)&stDelivery_Req, PacketSize, nTotalCount,  nCurrentCount, OPERATION_DELIVERY_REQ, pszAuthID, pszAuthKey);
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(stDelivery_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
	memcpy(stDelivery_Req.body.usGWID, pszGWID, strlen(pszGWID));

	if(pszDeviceID != NULL) //Device 판단
	{
		if(strlen(pszDeviceID) > LEN_DEVICE_ID) //Device ID 길이 확인
		{
		}
		else
		{
			memcpy(stDelivery_Req.body.usDeviceID, pszDeviceID, strlen(pszDeviceID));
		}
	}

	stDelivery_Req.body.ucReportType = cReportType;
	stDelivery_Req.body.ucMediaType = cMediaType;

	if(nMessageBodyLen > 0)
	{
		memcpy(stDelivery_Req.body.usMessageBody, pszMessageBody, nMessageBodyLen);
	}

	GMMP_Trace(&stDelivery_Req.header, &stDelivery_Req.body);

	nRet = GMMP_Delivery_Req(&stDelivery_Req, PacketSize);

	return nRet;
}

//제어 수신 기능은 Thread에서 처리
//제어 수신 보고  Response
int GMMP_SetControl(const char* pszAuthID, const char* pszAuthKey, const char* pszDomainCode, const char* pszGWID, const char* pszDeviceID, const char cControlType, const char cResultCode)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID ==NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nRet = GMMP_SUCCESS;

	Control_Rsp stControl_Rsp;

	memset(&stControl_Rsp, 0 ,sizeof(stControl_Rsp));

	nRet = SetHeader((void*)&stControl_Rsp, sizeof(stControl_Rsp), 1,  1, OPERATION_CONTROL_RSP, pszAuthID, pszAuthKey);
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(stControl_Rsp.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
	memcpy(stControl_Rsp.body.usGWID, pszGWID, strlen(pszGWID));

	if(pszDeviceID != NULL) //Device 판단
	{
		if(strlen(pszDeviceID) > LEN_DEVICE_ID) //Device ID 길이 확인
		{
		}
		else
		{
			memcpy(stControl_Rsp.body.usDeviceID, pszDeviceID, strlen(pszDeviceID));
		}
	}

	stControl_Rsp.body.ucControlType = cControlType;
	stControl_Rsp.body.ucResultCode = cResultCode;

	GMMP_Trace(&stControl_Rsp.header, &stControl_Rsp.body);

	nRet =  GMMP_Control_Rsp(&stControl_Rsp);

	return nRet;
}

//제어 동작 완료 결과 보고 Request
int GMMP_SetNotifi(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID,
		const char cControlType,
		const char cResultCode,
		const char* pszMessageBody,
		const int nMessageSize)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID ==NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nRet = GMMP_SUCCESS;

	Notifi_Req stNotifi_Req;

	memset(&stNotifi_Req, 0 ,sizeof(stNotifi_Req));

	int PacketSize =sizeof(stNotifi_Req) - MAX_MSG_BODY + nMessageSize ; //Message Body의 속성은 Optinal이다

	nRet = SetHeader((void*)&stNotifi_Req, PacketSize, 1,  1, OPERATION_NOTIFICATION_REQ, pszAuthID, pszAuthKey);
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(stNotifi_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
	memcpy(stNotifi_Req.body.usGWID, pszGWID, strlen(pszGWID));

	if(pszDeviceID != NULL) //Device 판단
	{
		if(strlen(pszDeviceID) > LEN_DEVICE_ID) //Device ID 길이 확인
		{
		}
		else
		{
			memcpy(stNotifi_Req.body.usDeviceID, pszDeviceID, strlen(pszDeviceID));
		}
	}

	stNotifi_Req.body.ucControlType = cControlType;
	stNotifi_Req.body.ucResultCode = cResultCode;

	if(pszMessageBody != NULL) //Message 사용 판단
	{
		if(nMessageSize > MAX_MSG_BODY)
		{
		}
		else
		{
			memcpy(stNotifi_Req.body.usMessageBody, pszMessageBody, nMessageSize);
		}
	}

	GMMP_Trace(&stNotifi_Req.header, &stNotifi_Req.body);

	nRet =  GMMP_Notifi_Req(&stNotifi_Req, PacketSize);

	return nRet;
}

int GMMP_SetHB(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID)
{
  /*
	if(pszAuthID == NULL
			|| pszAuthKey == NULL
			|| pszDomainCode == NULL
			|| pszGWID ==NULL
			|| strlen(pszAuthID) > LEN_AUTH_ID
			|| strlen(pszAuthKey) > LEN_AUTH_KEY
			|| strlen(pszDomainCode) > LEN_DOMAIN_CODE
			|| strlen(pszGWID) > LEN_GW_ID)
	{
		return LIB_PARAM_ERROR;
	}
  */

	int nRet = GMMP_SUCCESS;

	HB_Req stHB_Req;

	memset(&stHB_Req, 0 ,sizeof(stHB_Req));

	nRet = SetHeader((void*)&stHB_Req, sizeof(stHB_Req), 1,  1, OPERATION_HEARTBEAT_REQ, pszAuthID, pszAuthKey);
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(stHB_Req.body.usDomainCode, pszDomainCode, strlen(pszDomainCode));
	memcpy(stHB_Req.body.usGWID, pszGWID, strlen(pszGWID));

	GMMP_Trace(&stHB_Req.header, &stHB_Req.body);

	nRet =  GMMP_Heartbeat_Req(&stHB_Req);

	return nRet;
}

//GW/Device 등록/해지 Response
int GMMP_GetReg(GwRegist_Rsp* pstGwRegist_Rsp, DeviceRegist_Rsp* pstDeviceRegist_Rsp)
{
	int nRet = GMMP_SUCCESS;

	if(pstGwRegist_Rsp != NULL)
	{
		nRet = GMMP_GW_Reg_Rsp(pstGwRegist_Rsp);
		GMMP_Trace(&pstGwRegist_Rsp->header, &pstGwRegist_Rsp->body);
	}
	else
	{
		nRet = GMMP_Device_Reg_Rsp(pstDeviceRegist_Rsp);
		GMMP_Trace(&pstDeviceRegist_Rsp->header, &pstDeviceRegist_Rsp->body);
	}

	CloseSocket();

	return nRet;
}

int GMMP_GetDeReg(GwDeRegist_Rsp* pstGwRegist_Rsp, DeviceDeRegist_Rsp* pstDeviceDeRegist_Rsp)
{
	int nRet = GMMP_SUCCESS;

	if(pstGwRegist_Rsp != NULL)
	{
		nRet = GMMP_GW_DeReg_Rsp(pstGwRegist_Rsp);
		GMMP_Trace(&pstGwRegist_Rsp->header, &pstGwRegist_Rsp->body);
	}
	else
	{
		nRet = GMMP_Device_DeReg_Rsp(pstDeviceDeRegist_Rsp);
		GMMP_Trace(&pstDeviceDeRegist_Rsp->header, &pstDeviceDeRegist_Rsp->body);
	}

	CloseSocket();

	return nRet;
}

//Profile Info Response
int GMMP_GetProfile(Profile_Rsp* pstProfile_Rsp)
{
	int nRet = GMMP_Profile_Rsp(pstProfile_Rsp);

	GMMP_Trace(&pstProfile_Rsp->header, &pstProfile_Rsp->body);

	CloseSocket();

	return nRet;
}

//수집 데이터 보고  Response
int GMMP_GetDelivery(Delivery_Rsp* pstDelivery_Rsp)
{
	int nRet = GMMP_Delivery_Rsp(pstDelivery_Rsp);

	GMMP_Trace(&pstDelivery_Rsp->header, &pstDelivery_Rsp->body);

	CloseSocket();

	return nRet;
}
//제어 동작 완료 결과 보고 Response
int GMMP_GetNotifi(Notifi_Rsp* pstNotifi_Rsp)
{
	int nRet = GMMP_Notifi_Rsp(pstNotifi_Rsp);

	GMMP_Trace(&pstNotifi_Rsp->header, &pstNotifi_Rsp->body);

	CloseSocket();

	return nRet;
}

int GMMP_GetHB(HB_Rsp* pstHB_Rsp) //TCP Always ON 모드일 경우 (Thread 생성) 사용 TCP Disconnect하지 않음
{
	int nRet = GMMP_Heartbeat_Rsp(pstHB_Rsp);

	GMMP_Trace(&pstHB_Rsp->header, &pstHB_Rsp->body);

	return nRet;
}

int GMMP_Read(GMMPHeader* pstGMMPHeader, void** pBody)
{
  return GMMP_Read2(pstGMMPHeader, pBody, 1);
}

int GMMP_Read2(GMMPHeader* pstGMMPHeader, void** pBody, byte blocking)
{
	ConvertShort cvtShort;
	//ConvertInt cvtint;

	int nRet = 0;
	int nHeaderSize = sizeof(GMMPHeader);

	memset(pstGMMPHeader, 0, nHeaderSize);

	cvtShort.sU8 = 0;
	//cvtint.sU8 = 0;

	nRet = 0;

	nRet = ReadTCP2((char*)pstGMMPHeader, nHeaderSize, blocking);
	if (nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	memcpy(cvtShort.usShort, pstGMMPHeader->usMessageLength, sizeof(pstGMMPHeader->usMessageLength));
	cvtShort.sU8 = btols(cvtShort.sU8);

	if (cvtShort.sU8 < nHeaderSize)
	{
		return GMMP_HEADER_SIZE_ERROR;
	}

	int nBodySize = 0;

	if ((*pBody = MallocBody(pstGMMPHeader->ucMessageType, &nBodySize))== NULL || nBodySize <= 0)
	{
		return GMMP_MALLOC_ERROR;
	}

	memset(*pBody, 0, nBodySize);

	int ReadPacketSize = cvtShort.sU8 -  nHeaderSize;

	nRet = ReadTCP2((char*)(*pBody), ReadPacketSize, blocking);
	if(nRet != GMMP_SUCCESS)
	{
		CloseSocket();

		return nRet;
	}

	return GMMP_SUCCESS;
}

int GMMP_Recv(GMMPHeader* pstGMMPHeader, void* pBody)
{
	GMMP_Trace(pstGMMPHeader, pBody);

	char cMessageType =  pstGMMPHeader->ucMessageType ;

	if(cMessageType == OPERATION_GW_REG_RSP)
	{
		stGwRegistrationRspHdr* pstRspHdr =(stGwRegistrationRspHdr*) pBody;
		OG_Reg_Recv(pstGMMPHeader, pstRspHdr, NULL);
	}
	else if(cMessageType == OPERATION_GW_DEREG_RSP)
	{
		stGwDeRegistrationRspHdr* pstRspHdr =(stGwDeRegistrationRspHdr*) pBody;
		OG_DeReg_Recv(pstGMMPHeader, pstRspHdr, NULL);
	}
	else if(cMessageType  == OPERATION_PROFILE_RSP)
	{
		stProfileRspHdr* pstRspHdr =(stProfileRspHdr*) pBody;
		OG_Profile_Recv(pstGMMPHeader, pstRspHdr);
	}
	else if(cMessageType == OPERATION_DEVICE_REG_RSP)
	{
		stDeviceRegistrationRspHdr* pstRspHdr =(stDeviceRegistrationRspHdr*) pBody;
		OG_Reg_Recv(pstGMMPHeader, NULL, pstRspHdr);
	}
	else if(cMessageType == OPERATION_DEVICE_DEREG_RSP)
	{
		stDeviceDeRegistrationRspHdr* pstRspHdr =(stDeviceDeRegistrationRspHdr*) pBody;
		OG_DeReg_Recv(pstGMMPHeader, NULL,  pstRspHdr);
	}
	else if(cMessageType  == OPERATION_DELIVERY_RSP)
	{
		stPacketDeliveryRspHdr* pstRspHdr =(stPacketDeliveryRspHdr*) pBody;
		OG_Delivery_Recv(pstGMMPHeader,  pstRspHdr);
	}
	else if(cMessageType  == OPERATION_CONTROL_REQ)
	{
		stControlReqHdr* pstReqHdr =(stControlReqHdr*) pBody;
		GMMP_Ctrl_Recv(pstGMMPHeader,  pstReqHdr);
	}
	else if(cMessageType  == OPERATION_HEARTBEAT_RSP)
	{
		stHeartBeatMsgRspHdr* pstRspHdr =(stHeartBeatMsgRspHdr*) pBody;
		OG_HB_Recv(pstGMMPHeader,  pstRspHdr);
	}
	else if(cMessageType  == OPERATION_NOTIFICATION_RSP)
	{
		stNotificationRspHdr* pstRspHdr =(stNotificationRspHdr*) pBody;
		OG_Notifi_Recv(pstGMMPHeader,  pstRspHdr);
	}

	return GMMP_SUCCESS;
}

int GMMP_Ctrl_Recv(GMMPHeader* pstGMMPHeader,  stControlReqHdr* pstReqHdr)
{
	char cControlType = pstReqHdr->ucControlType;

	//단순 제어 명령어인 경우
	switch(cControlType)
	{
		case CONTROL_Reset:
				break;
		case CONTROL_Turn_Off:
				break;
		case CONTROL_Report_On:
				break;
		case CONTROL_Report_Off:
				break;
		case CONTROL_Time_Sync:
				break;
		case CONTROL_Pause:
				break;
		case CONTROL_Restart:
				break;
		case CONTROL_Signal_Power_Check:
				break;
		case CONTROL_Diagnostic:
				break;
		case CONTROL_Reserved:
				break;
		case CONTROL_Profile_Reset:
				break;
		case CONTROL_Status_Check:
				break;
		case CONTROL_FW_Download: //FTP 연결
				break;
		case CONTROL_FW_Update:
				break;
		case CONTROL_App_Download: //FTP 연결
				break;
		case CONTROL_App_Update:
				break;
		case CONTROL_Remote_Access: //Remote Info 연결
				break;
		case CONTROL_Multimedia_Control_Start: //Multimedia URL Info 연결
				break;
		case CONTROL_Multimedia_Control_Pause:
				break;
		case CONTROL_Multimedia_Control_Stop:
				break;
		case CONTROL_Multimedia_Control_Restart:
				break;
		default:
			break;
	}

	OG_Ctrl_Recv(pstGMMPHeader, pstReqHdr);

	return 1;
}

void SetTID(long nTid)
{
	g_nTID = nTid;
}

long GetTID()
{
	return g_nTID;
}

//protected
int SetHeader(void* pData,
		int nPacketSize,
		int nTotalCount,
		int nCurrentCount,
		const char cMessageType,
		const char* pszAuthID,
		const char* pszAuthKey)
{
	GMMPHeader* pHeader = (GMMPHeader*)pData;
	ConvertShort cvtShort;

//  debug(F("authID len = "));
//  debugln(strlen(pszAuthID));
	DBG("authID len = %d", strlen(pszAuthID));

	memset(pHeader, 0, sizeof(GMMPHeader));
	memset(cvtShort.usShort, 0, sizeof(cvtShort.usShort));

	pHeader->ucVersion = GMMP_VERSION;

	ConvertInt cvtInt;

	time_t t; time ( &t );

//  debug(F("TIME = "));
//  debugln(t);
	DBG("TIME = %d", t);

	memcpy(cvtInt.usInt, &t, sizeof(cvtInt.usInt));

	cvtInt.sU8 = ltobi(cvtInt.sU8);

	memcpy(&pHeader->unOriginTimeStamp, &cvtInt.usInt, sizeof(cvtInt.usInt));
	memcpy(&pHeader->usAuthID, pszAuthID, strlen(pszAuthID));

	if(pszAuthKey != NULL)
	{
		memcpy(&pHeader->usAuthKey, pszAuthKey, strlen(pszAuthKey));
	}

//  debug(F("TID = "));
//  debugln(g_nTID);
	DBG("TID = %ld", g_nTID);

	memcpy(&cvtInt.usInt, &g_nTID, sizeof(g_nTID));
	cvtInt.sU8 = ltobi(cvtInt.sU8);

	memcpy(pHeader->usTID, &cvtInt.usInt, sizeof(pHeader->usTID));

	cvtShort.sU8 = ltobs((short)nPacketSize);
	memcpy(pHeader->usMessageLength, cvtShort.usShort, sizeof(cvtShort.usShort));

	cvtShort.sU8 = ltobs((short)nTotalCount);
	memcpy(pHeader->usTotalCount, cvtShort.usShort, sizeof(cvtShort.usShort));

	cvtShort.sU8 = ltobs((short)nCurrentCount);
	memcpy(pHeader->usCurrentCount, cvtShort.usShort, sizeof(cvtShort.usShort));

	pHeader->ucMessageType = cMessageType;

	return GMMP_SUCCESS;
}

int SetIntiSocket(void)
{	
	return Connect();
}

char* MallocBody(const char Type, int* nBodySize)
{
	char* pBuffer = NULL;

	switch(Type)
	{
		case OPERATION_GW_REG_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stGwRegistrationRspHdr));
			*nBodySize = sizeof(stGwRegistrationRspHdr);
			break;
		}
		case OPERATION_GW_DEREG_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stGwDeRegistrationRspHdr));
			*nBodySize = sizeof(stGwDeRegistrationRspHdr);
			break;
		}
		case OPERATION_PROFILE_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stProfileRspHdr));
			*nBodySize = sizeof(stProfileRspHdr);
			break;
		}
		case OPERATION_DEVICE_REG_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stDeviceRegistrationRspHdr));
			*nBodySize = sizeof(stDeviceRegistrationRspHdr);
			break;
		}
		case OPERATION_DEVICE_DEREG_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stDeviceDeRegistrationRspHdr));
			*nBodySize = sizeof(stDeviceDeRegistrationRspHdr);
			break;
		}
		case OPERATION_DELIVERY_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stPacketDeliveryRspHdr));
			*nBodySize = sizeof(stPacketDeliveryRspHdr);
			break;
		}
		case OPERATION_CONTROL_REQ:
		{
			pBuffer = (char*)malloc(sizeof(stControlReqHdr));
			*nBodySize = sizeof(stControlReqHdr);
			break;
		}
		case OPERATION_HEARTBEAT_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stHeartBeatMsgRspHdr));
			*nBodySize = sizeof(stHeartBeatMsgRspHdr);
			break;
		}
		case OPERATION_NOTIFICATION_RSP:
		{
			pBuffer = (char*)malloc(sizeof(stNotificationRspHdr));
			*nBodySize = sizeof(stNotificationRspHdr);
			break;
		}
		default:
		{
			nBodySize = 0;
		}
	}

	return pBuffer;
}

int GMMP_Trace(GMMPHeader* pstGMMPHeader, void* pBody)
{
	ConvertInt cvtint;

	char cMessageType =  pstGMMPHeader->ucMessageType ;

	memcpy(cvtint.usInt, pstGMMPHeader->usTID, sizeof(pstGMMPHeader->usTID));
	cvtint.sU8 = btoli(cvtint.sU8);

	if(cMessageType == OPERATION_GW_REG_REQ)
	{
		stGwRegistrationReqHdr* pstRspHdr =(stGwRegistrationReqHdr*) pBody;
	}
	else if(cMessageType == OPERATION_GW_REG_RSP)
	{
		stGwRegistrationRspHdr* pstRspHdr =(stGwRegistrationRspHdr*) pBody;
	}
	else if(cMessageType == OPERATION_GW_DEREG_REQ)
	{
		stGwDeRegistrationReqHdr* pstRspHdr =(stGwDeRegistrationReqHdr*) pBody;
	}
	else if(cMessageType == OPERATION_GW_DEREG_RSP)
	{
		stGwDeRegistrationRspHdr* pstRspHdr =(stGwDeRegistrationRspHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_PROFILE_REQ)
	{
		stProfileReqHdr* pstRspHdr =(stProfileReqHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_PROFILE_RSP)
	{
		stProfileRspHdr* pstRspHdr =(stProfileRspHdr*) pBody;

		memcpy(cvtint.usInt, pstRspHdr->unHeartbeatPeriod, sizeof(pstRspHdr->unHeartbeatPeriod));
		cvtint.sU8 = btoli(cvtint.sU8);

		memcpy(cvtint.usInt, pstRspHdr->unReportPeriod, sizeof(pstRspHdr->unReportPeriod));
		cvtint.sU8 = btoli(cvtint.sU8);

		memcpy(cvtint.usInt, pstRspHdr->unReportOffset, sizeof(pstRspHdr->unReportOffset));
		cvtint.sU8 = btoli(cvtint.sU8);

		memcpy(cvtint.usInt, pstRspHdr->unResponseTimeout, sizeof(pstRspHdr->unResponseTimeout));
		cvtint.sU8 = btoli(cvtint.sU8);
	}
	else if(cMessageType == OPERATION_DEVICE_REG_REQ)
	{
		stDeviceRegistrationReqHdr* pstRspHdr =(stDeviceRegistrationReqHdr*) pBody;
	}
	else if(cMessageType == OPERATION_DEVICE_REG_RSP)
	{
		stDeviceRegistrationRspHdr* pstRspHdr =(stDeviceRegistrationRspHdr*) pBody;
	}
	else if(cMessageType == OPERATION_DEVICE_DEREG_REQ)
	{
		stDeviceDeRegistrationReqHdr* pstRspHdr =(stDeviceDeRegistrationReqHdr*) pBody;
	}
	else if(cMessageType == OPERATION_DEVICE_DEREG_RSP)
	{
		stDeviceDeRegistrationRspHdr* pstRspHdr =(stDeviceDeRegistrationRspHdr*) pBody;
	}
	else if(cMessageType == OPERATION_DELIVERY_REQ)
	{
		stPacketDeliveryReqHdr* pstRspHdr =(stPacketDeliveryReqHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_DELIVERY_RSP)
	{
		stPacketDeliveryRspHdr* pstRspHdr =(stPacketDeliveryRspHdr*) pBody;

		memcpy(cvtint.usInt, pstRspHdr->unBackOffTime, sizeof(pstRspHdr->unBackOffTime));
		cvtint.sU8 = btoli(cvtint.sU8);
	}
	else if(cMessageType  == OPERATION_CONTROL_REQ)
	{
		stControlReqHdr* pstReqHdr =(stControlReqHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_CONTROL_RSP)
	{
		stControlRspHdr* pstRspHdr =(stControlRspHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_HEARTBEAT_REQ)
	{
		stHeartBeatMsgRspHdr* pstRspHdr =(stHeartBeatMsgRspHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_HEARTBEAT_RSP)
	{
		stHeartBeatMsgRspHdr* pstRspHdr =(stHeartBeatMsgRspHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_NOTIFICATION_REQ)
	{
		stNotificationReqHdr* pstRspHdr =(stNotificationReqHdr*) pBody;
	}
	else if(cMessageType  == OPERATION_NOTIFICATION_RSP)
	{
		stNotificationRspHdr* pstRspHdr =(stNotificationRspHdr*) pBody;
	}

	return GMMP_SUCCESS;
}
