/** GMMP 내부함수 및 변수 설명
  * @date 2013/11/21
 * @version 0.0.0.1
 * @file GMMP_Operation.h
 **/

#ifndef GMMP_OPERATION_H_
#define GMMP_OPERATION_H_

#include "GMMP_Control.h"
#include "GMMP_Delivery.h"
#include "GMMP_Heartbeat.h"
#include "GMMP_Notification.h"
#include "GMMP_ProfileInfo.h"
#include "GMMP_Reg.h"
#include "Network.h"
#include "GMMP.h"

/**
 * @brief GW/Device 등록/해지 Request 기능
 * @param pszAuthID Auth ID 문자열 입력
 * @param pszAuthKey Auth Key 문자열 입력
 * @param pszDomainCode Domain Code
 * @param pszGWID GW ID
 * @param pszManufactureID
 * @return
 */
int GMMP_SetReg(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszManufactureID);

/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @return
 */
/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @return
 */
/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @return
 */
/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @return
 */
int GMMP_SetDeReg(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID);
/**
 *
 * @param pstGwRegist_Rsp
 * @param pstDeviceRegist_Rsp
 * @return
 */
int GMMP_GetReg(GwRegist_Rsp* pstGwRegist_Rsp, DeviceRegist_Rsp* pstDeviceRegist_Rsp);

/**
 *
 * @param pstGwRegist_Rsp
 * @param pstDeviceDeRegist_Rsp
 * @return
 */
int GMMP_GetDeReg(GwDeRegist_Rsp* pstGwRegist_Rsp, DeviceDeRegist_Rsp* pstDeviceDeRegist_Rsp);

/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @return
 */
int GMMP_SetProfile(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID);
/**
 *
 * @param pstProfile_Rsp
 * @return
 */
int GMMP_GetProfile(Profile_Rsp* pstProfile_Rsp);
/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @param cReportType
 * @param cMediaType
 * @param pszMessageBody
 * @param nTotalCount
 * @param nCurrentCount
 * @return
 */
int GMMP_SetDelivery(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID,
		const char cReportType,
		const char cMediaType,
		const char* pszMessageBody,
		const int nTotalCount,
		const int nCurrentCount);
/**
 *
 * @param pstDelivery_Rsp
 * @return
 */
int GMMP_GetDelivery(Delivery_Rsp* pstDelivery_Rsp);

/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @param cControlType
 * @param cResultCode
 * @return
 */
int GMMP_SetControl(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID,
		const char cControlType,
		const char cResultCode);

/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @param pszDeviceID
 * @param cControlType
 * @param cResultCode
 * @param pszMessageBody
 * @param nMessageSize
 * @return
 */
int GMMP_SetNotifi(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID,
		const char* pszDeviceID,
		const char cControlType,
		const char cResultCode,
		const char* pszMessageBody,
		const int nMessageSize);

/**
 *
 * @param pstNotifi_Rsp
 * @return
 */
int GMMP_GetNotifi(Notifi_Rsp* pstNotifi_Rsp);

/**
 *
 * @param pszAuthID
 * @param pszAuthKey
 * @param pszDomainCode
 * @param pszGWID
 * @return
 */
int GMMP_SetHB(const char* pszAuthID,
		const char* pszAuthKey,
		const char* pszDomainCode,
		const char* pszGWID);

/**
 *
 * @param pstHB_Rsp
 * @return
 */
int GMMP_GetHB(HB_Rsp* pstHB_Rsp);

/**
 *
 * @param pstGMMPHeader
 * @param pBody
 * @return
 */
int GMMP_Read(GMMPHeader* pstGMMPHeader, void** pBody);
int GMMP_Read2(GMMPHeader* pstGMMPHeader, void** pBody, byte blocking);
/**
 *
 * @param pstGMMPHeader
 * @param pBody
 * @return
 */
int GMMP_Recv(GMMPHeader* pstGMMPHeader, void* pBody);
/**
 *
 * @param pstGMMPHeader
 * @param pstRspHdr
 * @return
 */
int GMMP_Ctrl_Recv(GMMPHeader* pstGMMPHeader,  stControlReqHdr* pstRspHdr);
/**
 *
 * @param pstGMMPHeader
 * @param pBody
 * @return
 */
int GMMP_Trace(GMMPHeader* pstGMMPHeader, void* pBody);

/**
 *
 * @param nTid
 */
void SetTID(long nTid);
/**
 *
 * @return
 */
long GetTID();

/**
 *
 * @param pData
  * @param nPacketSize
 * @param nTotalCount
 * @param nCurrentCount
 * @param cMessageType
 * @param pszAuthID
 * @param pszAuthKey
 * @return
 */
int SetHeader(void* pData,
		int nPacketSize,
		int nTotalCount,
		int nCurrentCount,
		const char cMessageType,
		const char* pszAuthID,
		const char* pszAuthKey);

/**
 *
 * @return
 */
int SetIntiSocket(void);

/**
 *
 * @param Type
 * @param nOutBufferSize
 * @return
 */
char* MallocBody(const char Type, int* nOutBufferSize);

#endif /* GMMP_OPERATION_H_ */
