/** GMMP 공통 정의
 * @file GMMP.cpp
 * @date 2015/07/20
 * @version 0.0.1.0
 **/

#ifndef GMMP_h
#define GMMP_h

/*
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <pthread.h>
#include <unistd.h>
#include <stdarg.h>
*/

//#include <inttypes.h>
//#include <Time.h>
//#include <Arduino.h>

#include "config.h"

#include "Client.h"

/** moved to config.h
//#define USE_SNIC_WIFI //Murata Type YD Wi-Fi
//#define USE_WIZNET_W5500
 **/

// Added the code for LPC1768 platform
#if defined(TARGET_LPC1768) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)

	#ifdef USE_SNIC_WIFI
	#include "SNIC_WifiInterface.h"
	C_SNIC_WifiInterface     wifi( D8, D2, NC, NC, D3);

/** moved to config.h
//	#define MBED_AP_SSID                  "FON"//"TIDE867"//"tide855" 
//	/** Securiry Options
//	e_SEC_OPEN       = 0x00, //Open
//	e_SEC_WEP        = 0x01, // WEP
//	e_SEC_WPA_TKIP   = 0x02, // WPA-PSK(TKIP)
//	e_SEC_WPA2_AES   = 0x04, // WPA2-PSK(AES)
//	e_SEC_WPA2_MIXED = 0x06, // WPA2-PSK(TKIP/AES)
//	e_SEC_WPA_AES    = 0x07  // WPA-PSK(AES) **/
//	#define MBED_AP_SECURITY_TYPE         e_SEC_OPEN//e_SEC_WPA2_AES//e_SEC_OPEN
//	#define MBED_AP_SECUTIRY_KEY          ""//"tidetide"
// **/

	#endif//USE_SNIC_WIFI
	
	#ifdef USE_WIZNET_W5500
	#include "WIZnetInterface.h"	
	#endif//USE_WIZNET_W5500
#endif

#include "NTPClient.h"

#include "GMMP.h"

byte g_serverIp[LEN_IP] ; ///< 서버 IP 정보를 저장한다.
int  g_nServerPort = 0; ///<  서버 Port 정보를 저장한다.

char g_szAuthID[LEN_AUTH_ID];///< OMP Portal을 통해 사전에 등록된 M2M GW 의 Serial Number 저장 변수, 자동화를 위해 사용된다.

char g_szAuthKey[LEN_AUTH_KEY]; ///< 등록 절차 시 OMP에서 할당 받은 AuthKey 저장 변수, 자동화를 위해 사용된다.

char g_szDomainCode[LEN_DOMAIN_CODE]; ///< OMP Portal을 통해 사전에 등록된 서비스 영역별 구분 코드 저장 변수, 자동화를 위해 사용된다.

char g_szGWID[LEN_GW_ID]; ///< OMP에서 할당 받은 Gateway의 ID 문자열 저장 변수, 자동화를 위해 사용된다.

Client *g_pClient = NULL;

/**
 * @brief OMP서버로 부터 수신한 패킷을 제공할 콜백함수 포인트 구조체
 * @param pstGMMPHeader GMMP Header의 구조체 포인트
 * @param pstBody GMMP Body의 구조체 포인트
 * @return 성공:0, 실패: 1이상 , 에러코드 참조
 */
typedef int (*callback_Reg)(GMMPHeader* pstGMMPHeader, void* pstBody);

callback_Reg g_CallFunctionRegRecv = NULL; ///< OMP서버로 부터 수신한 패킷을 제공할 콜백함수 포인트 변수.
//callback_Reg g_CallHeartbeatRegRecv = NULL; ///< OMP서버로 부터 수신한 패킷 중 Heartbeat 패킷을 제공할 콜백함수 포인트 변수. (TCP Always On mode에서만 사용된다.)

void Uninitialize()
{
	InitMemory();
	CloseSocket();
}



int Initialize(byte* serverIp,
		const int nPort,
		const char* pszDomainCode,
		const char* pszGWAuthID,
		byte* mac)
{
  debugln("Initialize()");

	InitMemory();

	//delay(2000);
	//NTPClient ntp;
	
	infoln("Getting IP...");

	#ifdef USE_SNIC_WIFI
	wifi.init();

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 ) {
        return -1;
    }

    wait(0.3);
    // Connect AP
    wifi.connect( MBED_AP_SSID
                  , strlen(MBED_AP_SSID)
                  , MBED_AP_SECURITY_TYPE
                  , MBED_AP_SECUTIRY_KEY
                  , strlen(MBED_AP_SECUTIRY_KEY) );
    wait(0.5);
    wifi.setIPConfig( true );     //Use DHCP
    wait(0.5);
    
    tagWIFI_STATUS_T wifi_status;
    if( wifi.getWifiStatus(&wifi_status) ) printf("wifi_status error!\r\n");

    printf("MAC Address is %02x:%02x:%02x:%02x:%02x:%02x\r\n",
    	wifi_status.mac_address[0], wifi_status.mac_address[1], wifi_status.mac_address[2],
    	wifi_status.mac_address[3], wifi_status.mac_address[4], wifi_status.mac_address[5]);
    printf("IP Address is %s\r\n", wifi.getIPAddress());
    #endif//USE_SNIC_WIFI

	#ifdef USE_WIZNET_W5500

	#if defined(TARGET_LPC1768) 
		SPI spi(p5, p6, p7); // mosi, miso, sclk
		WIZnetInterface ethernet(&spi, p8, p11);
	#elif defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_NUCLEO_L152RE)
		SPI spi(PA_7, PA_6, PA_5); // mosi, miso, sclk	
		WIZnetInterface ethernet(&spi, PB_6, PA_9);//scs(PB_6), nRESET(PA_9); // reset pin is dummy, don't affect any pin of WIZ550io     
	#else
		// Ethernet interface initialization code for additional platforms will be added later.
	#endif

	//mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
	
		#if defined(TARGET_NUCLEO_F411RE)
		wait(0.5);
    	//spi.format(8,3);          // Setup:  bit data, high steady state clock, 2nd edge capture
    	//spi.frequency(25000000);    // SPI Clock; 25MHz (default: 1MHz)
    	spi.frequency(12000000);    // SPI Clock; 12.5MHz (default: 1MHz)
		wait(0.5);
		#endif
			
    printf("input MAC Address is %02x:%02x:%02x:%02x:%02x:%02x\r\n",
    	mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
	
	int ret = ethernet.init(mac);
    //printf("SPI Initialized \r\n");
    //wait(1); // 1 second for stable state
    
    printf("W5500 Networking Started \r\n");
    //wait(1); // 1 second for stable state

    if (!ret) {
        printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            printf("Error ethernet.connect() - ret = %d\r\n", ret);
            //exit(0);
        }
    } else {
        printf("Error ethernet.init() - ret = %d\r\n", ret);
        //exit(0);
    }

	#endif//USE_WIZNET_W5500
    
	NTPClient ntp;
	printf("Trying to update time...\r\n");
	//if (ntp.setTime("0.pool.ntp.org") == 0)
//	if (ntp.setTime("time-a.timefreq.bldrdoc.gov") == 0)
//	if (ntp.setTime("kr.pool.ntp.org") == 0)
//	if (ntp.setTime("112.220.115.166") == 0)
	if (ntp.setTime("211.233.40.78") == 0) //MURATA UDP does not support DNS resolver...
	{
	  printf("Set time successfully\r\n");
	  time_t ctTime;
	  ctTime = time(NULL);
//	  printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
      ctTime += 32400; // GMT+9/Seoul
	  printf("Time is set to (GMT+9): %s\r\n", ctime(&ctTime));
	}
	else
	{
	  printf("Error\r\n");
	} 
		
	g_pClient = new Client; //lesmin

	if(SetServerInfo(serverIp, nPort, pszGWAuthID, pszDomainCode) != 0)
	{
		return LIB_PARAM_ERROR;
	}

	SetTID(0);

	return GMMP_SUCCESS;
}

void SetAuthKey(const char* pszAuthKey)
{
	memcpy(g_szAuthKey, pszAuthKey, strlen(pszAuthKey));
}

void SetGWID(const char* pszGWID)
{
	if(pszGWID != NULL)
	{
		memcpy(g_szGWID, pszGWID, strlen(pszGWID));
	}
}

char* GetGWID()
{
	return g_szGWID;
}

int SetServerInfo(byte* serverIp, int nPort, const char* pszAuthID, const char* pszDoamainCode)
{
  /*
	if(pszAuthID == NULL || strlen(pszAuthID) > LEN_AUTH_ID
			|| pszDoamainCode == NULL || strlen(pszDoamainCode) > LEN_DOMAIN_CODE)
	{
		return LIB_PARAM_ERROR;
	}
  */

	memcpy(g_serverIp, serverIp, LEN_IP);
	memcpy(g_szAuthID, pszAuthID, strlen(pszAuthID));
	memcpy(g_szDomainCode, pszDoamainCode, strlen(pszDoamainCode));

	g_nServerPort = nPort;

	int nRet = SetIntiSocket();
	if(nRet != GMMP_SUCCESS)
	{
		return nRet;
	}

	return GMMP_SUCCESS;
}

void SetCallFunction(int (* pCallFunctionName)(GMMPHeader* pstGMMPHeader, void* pstBody))
{
	g_CallFunctionRegRecv = (callback_Reg)pCallFunctionName;
}

int GO_Reg(const char* pszGWID,
		const char* pszManufactureID)
{
  debugln("GO_Reg()");
	SetTID(GetTID()+1);

	int nRet = GMMP_SetReg(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszManufactureID);
  debugln("GO_SetReg() Done");

	return nRet;
}

int GO_DeReg(const char* pszGWID, const char* pszDeviceID)
{
	SetTID(GetTID()+1);

	int nRet = GMMP_SetDeReg(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszDeviceID);

	return nRet;
}

int GO_Profile(const char* pszGWID,
		const char* pszDeviceID,
		const long nTID /*=0*/)
{
	if(nTID == 0) {
		SetTID(GetTID()+1);
	} else {
		SetTID(nTID);
	}

	int nRet = GMMP_SetProfile(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszDeviceID);

  return nRet;
}

int GO_Delivery(const char* pszGWID,
		const char* pszDeviceID,
		const char cReportType,
		const char cMediaType,
		const char* pszMessageBody)
{
	SetTID(GetTID()+1);

	int nRet = GMMP_SetDelivery(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszDeviceID, cReportType, cMediaType, pszMessageBody, 1, 1);

	return nRet;
}

int GO_Control(const char* pszGWID,
		const char* pszDeviceID,
		long nTID,
		const char cControlType,
		const char cResultCode)
{
	SetTID(nTID);

	return GMMP_SetControl(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszDeviceID, cControlType, cResultCode);
}

int GO_Notifi(const char* pszGWID,
		const char* pszDeviceID,
		const char cControlType,
		const char cResultCode,
		const char* pszMessageBody,
		const int nMessageBodySize)
{
	int nRet =	GMMP_SetNotifi(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID, pszDeviceID, cControlType, cResultCode, pszMessageBody, nMessageBodySize);

	return nRet;
}

int GO_HB(const char* pszGWID)
{
	int nRet =	GMMP_SetHB(g_szAuthID, g_szAuthKey, g_szDomainCode, pszGWID);

	return nRet;
}

int OG_Reg_Recv(GMMPHeader* pstGMMPHeader, stGwRegistrationRspHdr* pstGWBody, stDeviceRegistrationRspHdr* pstDeviceBody)
{
	int nRet = 0;

	if(g_CallFunctionRegRecv != NULL)
	{
		if(pstGWBody != NULL)
		{
			nRet= (*g_CallFunctionRegRecv)(pstGMMPHeader, pstGWBody);

			if(nRet != GMMP_SUCCESS)
			{
				return nRet;
			}
		}
		else
		{
			nRet = (*g_CallFunctionRegRecv)(pstGMMPHeader, pstDeviceBody);

			if(nRet != GMMP_SUCCESS)
			{
				return nRet;
			}
		}
	}

	return GMMP_SUCCESS;
}

int OG_DeReg_Recv(GMMPHeader* pstGMMPHeader, stGwDeRegistrationRspHdr* pstGWBody, stDeviceDeRegistrationRspHdr* pstDeviceBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		if(pstGWBody != NULL)
		{
			return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstGWBody);
		}
		else
		{
			return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstDeviceBody);
		}
	}

	return GMMP_SUCCESS;
}

int OG_Profile_Recv(GMMPHeader* pstGMMPHeader, stProfileRspHdr* pstBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstBody);
	}

	return GMMP_SUCCESS;
}

int OG_Delivery_Recv(GMMPHeader* pstGMMPHeader, stPacketDeliveryRspHdr* pstBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstBody);
	}

	return GMMP_SUCCESS;
}

int OG_Ctrl_Recv(GMMPHeader* pstGMMPHeader, stControlReqHdr* pstBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstBody);
	}

	return GMMP_SUCCESS;
}

int OG_HB_Recv(GMMPHeader* pstGMMPHeader, stHeartBeatMsgRspHdr* pstBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstBody);
	}

	return GMMP_SUCCESS;
}

int OG_Notifi_Recv(GMMPHeader* pstGMMPHeader, stNotificationRspHdr* pstBody)
{
	if(g_CallFunctionRegRecv != NULL)
	{
		return (*g_CallFunctionRegRecv)(pstGMMPHeader, pstBody);
	}

	return GMMP_SUCCESS;
}

int GetReadData(GMMPHeader* pstGMMPHeader, void** pBody)
{
	int nHeaderCound = 0;
	int nRet = 0;
  
	while(true)
	{
		nRet = GMMP_Read(pstGMMPHeader, pBody);
		if(nRet == GMMP_HEADER_SIZE_ERROR) {
			if(nHeaderCound > 3) {
				break;
			}
			nHeaderCound++;
			continue;
		}
		else if(nRet == GMMP_SUCCESS) {
			break;
		}
		else {
			return nRet;
		}
	}

	GMMP_Recv(pstGMMPHeader, *pBody);

	return nRet;
}

long Char2int(void* pBuffer, int nSize)
{
	if(nSize != sizeof(long)) {
		return 0;
	}

	long nInt = 0;
	memcpy(&nInt, pBuffer, sizeof(long));
	return btoli(nInt);
}

int Char2short(void* pBuffer, short nSize)
{
	if(nSize != sizeof(short)) {
		return 0;
	}

	short nShort = 0;
	memcpy(&nShort, pBuffer, sizeof(short));
	return btols(nShort);
}

void InitMemory()
{
	memset(g_szDomainCode, 0 , sizeof(g_szAuthID));
	memset(g_szAuthID, 0 , sizeof(g_szAuthID));
	memset(g_szAuthKey, 0 , sizeof(g_szAuthKey));
	memset(g_szGWID, 0 , sizeof(g_szGWID));

	g_nServerPort = 0;

	g_CallFunctionRegRecv = NULL;
}

#endif
