/** TCP Socket 통신을 위한 모듈
 * @file Network.cpp
 * @date 2015/07/20
 * @version 0.0.1.0
 **/

#include "Client.h"

#include "Network.h"
#include "GMMP_Operation.h"

int g_socket = -1;

//Client client;
extern Client *g_pClient; //lesmin

void CloseSocket()
{
	if (g_socket <= 0) return;

	g_socket = -1;
	
	return;
}

int CheckSocket()
{
	return 0;
}

int Connect()
{  
  int ret = GMMP_SUCCESS;  

  //delay(2000);
  infoln("Connecting...");
  INFO("server ip: %d.%d.%d.%d:%d", g_serverIp[0], g_serverIp[1], g_serverIp[2], g_serverIp[3], g_nServerPort);

  char szServerIp[24];
  sprintf(szServerIp, "%d.%d.%d.%d", g_serverIp[0], g_serverIp[1], g_serverIp[2], g_serverIp[3]);

	if(g_pClient == NULL) {
		ERR("pClient is NULL!!!");
		return LIB_PARAM_ERROR;
	}

//  if (client.connect((char *)szServerIp, g_nServerPort)) {
	/*
	if (g_pClient->connect((char *)szServerIp, g_nServerPort)) {
		infoln("Connected!!");
	} else {
		infoln("connection failed!");
		ret = SERVER_CONNECT_ERROR;
	}
	*/
	int retry = 30;
	do
	{		
		if(retry <= 0) {
			ret = SERVER_CONNECT_ERROR;
			break;
		}
		
		infoln("Trying to connect to Server...");
		if (g_pClient->connect((char *)szServerIp, g_nServerPort)) {
			infoln("Connected!");
			break;
		}	
		
		infoln("Connection failed!");
	} while(retry--);

	return ret;
}

int WriteTCP(char* pBuf, int nLen)
{
	DBG("WriteTCP(): %d", nLen);

	if (pBuf == NULL || nLen <= 0) return LIB_PARAM_ERROR;

	if(g_pClient == NULL) {
		ERR("pClient is NULL!!!");
		return LIB_PARAM_ERROR;
	}
//  client.write(pBuf, nLen);
	g_pClient->write(pBuf, nLen);

	return GMMP_SUCCESS;
}

int ReadTCP(char* pBuf, const int nMaxlen)
{
  return ReadTCP2(pBuf, nMaxlen, 1);
}

int ReadTCPAsync(char* pBuf, const int nMaxlen);

int ReadTCP2(char* pBuf, const int nMaxlen, byte blocking)
{
  //blocking = 0;

  if (!blocking) {
    return ReadTCPAsync(pBuf, nMaxlen);
  }

	if (pBuf == NULL || nMaxlen <= 0) return LIB_PARAM_ERROR;

	if(g_pClient == NULL) {
		ERR("pClient is NULL!!!");
		return LIB_PARAM_ERROR;
	}

	int idx = 0;
	memset(pBuf,  0, nMaxlen);

	while(idx < nMaxlen)
	{
//    if (client.available()) {
    if (g_pClient->available()) {
//		  pBuf[idx] = client.read();
		  pBuf[idx] = g_pClient->read();
      DBG("%d", idx);
      DBG(" %c",(byte)pBuf[idx]);
      idx++;
    } else {
      //debugln("E_WOULDBLOCK");
      return E_WOULDBLOCK;
    }
	}

	return GMMP_SUCCESS;
}

int ReadTCPAsync(char* pBuf, const int nMaxlen)
{
	if (pBuf == NULL || nMaxlen <= 0) return LIB_PARAM_ERROR;

	if(g_pClient == NULL) {
		ERR("pClient is NULL!!!");
		return LIB_PARAM_ERROR;
	}

	int idx = 0;
  char val = -1;

	memset(pBuf,  0, nMaxlen);

	while(idx < nMaxlen)
	{
//    val = client.read();
    val = g_pClient->read();

    if (val != -1) {
		  pBuf[idx++] = (byte)val;
      
      /*
		  pBuf[idx] = (byte)val;
      debug(idx);
      debug(" ");
      debugln((byte)pBuf[idx]);
      idx++;
      */
    } else {
      return E_WOULDBLOCK;
    }
	}

	return GMMP_SUCCESS;
}
