#include "mbed.h"

DigitalOut GENLED(LED1);         //LED for AD9833 output
DigitalOut DDSLED(LED2);        //LED for AD9850 output

Thread GENthread;                   //create thread to allow simultaneous LED blink and DDS output
Thread LEDthread; 

//AD9833 LED thread
void GENBlinkThread() {
    while (true) {
        GENLED = !GENLED;
        Thread::wait(100);     
    }
}

//AD9850 LED thread
void DDSBlinkThread() {
    while (true) {
        DDSLED = !DDSLED;
        Thread::wait(500);
    }
}

int main() {
    GENthread.start(callback(GENBlinkThread));
    LEDthread.start(callback(DDSBlinkThread));
    
    GENthread.join();                   //wait for the threads to finish
    LEDthread.join();
   
    while(1);
}
