#include "mbed.h"
#include "HIDScope.h"

// Define the storage variables and filter coefficients for two filters
AnalogIn    emg(A0);  //Analog input EMG
Ticker biquadTicker;
double f1_v1=0, f1_v2=0, f2_v1=0, f2_v2=0, f3_v1=0, f3_v2=0;                                                            //v staat uitgelegd in de slides van DRS  
const double f1_a1=-1.05803167147, f1_a2=0.30140492806, f1_b0=1.00000000000, f1_b1=1.72709218153, f1_b2=1.00000000000;  //f1 = filter 1, f2 = filter 2, etc
const double f2_a1=-1.11021886292, f2_a2=0.48182066030, f2_b0=1.00000000000, f2_b1=0.60923103465, f2_b2=1.00000000000;  //a0 is altijd 1, daarom hoeft die niet afgelezen te worden uit ASN filter
const double f3_a1=-1.25016584003, f3_a2=0.79376337310, f3_b0=1.00000000000, f3_b1=0.03012561298, f3_b2=1.00000000000;  //bij dit voorbeeld zijn er 3 filters nodig

double biquad(double u, double &v1, double &v2,//input and storage variables. v1 en v2 moeten worden verandert, daarom staat er een & voor
    const double a1, const double a2, const double b0, const double b1, const double b2){
        double v = u-a1*v1-a2*v2;       //Deze formule komt uit de slides van DRS
        double y = b0*v+b1*v1+b2*v2;    //Deze formule komt ook uit de slides van DRS 
        v2=v1; v1=v;    
        return y;
}

//This is your controller, call it using a Ticker
void myController(){
    double u1 = 0.118800*emg.read(), u2 = 0.139873*emg.read(), u3 = 0.149838*emg.read();    //Dit zijn de gains uit ASN filter
    double y1 = biquad(u1, f1_v1, f1_v2, f1_a1, f1_a2, f1_b0, f1_b1, f1_b2);                //Vul hier de u, v1, v2, a1, a2, b0, b1 en b2 van de juist filter in
    double y2 = biquad(u2, f2_v1, f2_v2, f2_a1, f2_a2, f2_b0, f2_b1, f2_b2);
    double y3 = biquad(u3, f3_v1, f3_v2, f3_a1, f3_a2, f3_b0, f3_b1, f3_b2);
}

int main(){
    biquadTicker.attach(&myController,0.01f);   //100 Hz
}

//DE RESULTATEN VAN ASN FILTER BIJ EEN RANDOM LAAGDOORLAATFILTER
//Biquad #1
//Gain = 0.118800
//B = [ 1.00000000000,  1.72709218153,  1.00000000000]
//A = [ 1.00000000000, -1.05803167147,  0.30140492806]

// Gain is u in de code en B is b0 t/m b2 en A is a0 t/m a2

//Biquad #2
//Gain = 0.139873
//B = [ 1.00000000000,  0.60923103465,  1.00000000000]
//A = [ 1.00000000000, -1.11021886292,  0.48182066030]

//Biquad #3
//Gain = 0.149838
//B = [ 1.00000000000,  0.03012561298,  1.00000000000]
//A = [ 1.00000000000, -1.25016584003,  0.79376337310]
