/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "freetronicsLCDShield.h"

freetronicsLCDShield lcd(D12, D11, D10, D9, D8, D7, D3, A0);



/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
//static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
//static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if(fractPart >= i) break;
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}


/* Simple main function */
int main() {
  uint8_t id;
  float value1, value2;
  char buffer1[32], buffer2[32];
  int32_t axes[3];
  int32_t m[3];
  int32_t n[3];
  int32_t r;
  int32_t i;
  int32_t lock_unlock=0;
  int temp=0;
  
   // turn on the back light (it's off by default)
    lcd.setBackLight(true);
    
    // print the first line and wait 3 sec
    lcd.printf("Starting ESEproc");
    wait(2);
  
  
  printf("\r\n--- Starting ESEproc ---\r\n");
  
  
 
    
    // print the counter prefix; the number will be printed in the while loop
    lcd.setCursorPosition(1, 0);
    lcd.printf("Initializing...");

  humidity_sensor->ReadID(&id);
  printf("HTS221  humidity & temperature    = 0x%X\r\n", id);
  //pressure_sensor->ReadID(&id);
 // printf("LPS25H  pressure & temperature    = 0x%X\r\n", id);
  //magnetometer->ReadID(&id);
  //printf("LIS3MDL magnetometer              = 0x%X\r\n", id);
  gyroscope->ReadID(&id);
  printf("LSM6DS0 accelerometer & gyroscope = 0x%X\r\n", id);
  
  DigitalOut myled(LED1);
  DigitalIn mybutton(USER_BUTTON);
  
  wait(2);
  
      // turn off the back light 
    lcd.setBackLight(false);
 
  while(1) {
    wait(0.001);
    printf("\r\n");
    
    temp_sensor1->GetTemperature(&value1); 
    humidity_sensor->GetHumidity(&value2);
    
    // print the Temperature and Humidity 
    lcd.cls();
    lcd.setBackLight(false);
    lcd.printf("T:%4s C", printDouble(buffer1, value1));

    
    lcd.setCursorPosition(1, 0);
    lcd.printf("H:%s %%", printDouble(buffer2, value2));
    if ((value1>37) && (value2>80))
        {
           myled=1;

           printf("Excessive Temperature & Excessive Humidity\r\n");
           lcd.setBackLight(true);
           lcd.setCursorPosition(0, 12);
           lcd.printf("T");
           lcd.setCursorPosition(1, 12);
           lcd.printf("H");        
           wait(0.1);
           myled=0;
        }
    if ((value1>37) && (value2<=80))
        {
            myled=1;

            printf("Excessive Temperature\r\n");
            lcd.setBackLight(true);
            lcd.setCursorPosition(0, 12);
            lcd.printf("T");
            wait(0.4);
            myled=0;
        }
    if ((value1<=37) && (value2>80))
        {
            myled=1;

            printf("Excessive Humidity\r\n");
            lcd.setBackLight(true);
            lcd.setCursorPosition(1, 12);
            lcd.printf("H");
            wait(0.8);
            myled=0;
        }
    
    
    printf("HTS221: [temp] %7s°C,   [hum] %s%%\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));
    

    
  //  temp_sensor2->GetFahrenheit(&value1);
    //pressure_sensor->GetPressure(&value2);
    //printf("LPS25H: [temp] %7s°F, [press] %smbar\r\n", printDouble(buffer1, value1), printDouble(buffer2, value2));

   
 //           if (temp>=100){
 //               lock_unlock =! lock_unlock;
  //              myled=1;
 //               wait(0.2);
 //               myled=0;
 //               wait(0.2);
 //               myled=1;
  //              wait(0.2);
 //               myled=0;
 //               }
     
    if (lock_unlock == 0)
        {
        printf("SecuritySystemON\r\n");
        lcd.setCursorPosition(0, 15);
        lcd.printf("S");
        accelerometer->Get_X_Axes(axes);
        for (i=0;i<3;i++)
            {
                m[i]=axes[i];
            }
        wait(0.2);
        accelerometer->Get_X_Axes(axes);
        for (i=0;i<3;i++)
            {
                n[i]=axes[i];
            }
        r=(m[0]-n[0])*(m[0]-n[0])+(m[1]-n[1])*(m[1]-n[1])+(m[2]-n[2])*(m[2]-n[2]);
        if(r>1500)
            {
                myled=1;
                printf("Security Alert\r\n");
                lcd.cls();
                lcd.setBackLight(true);
                lcd.printf("Security Alert");
                lcd.setCursorPosition(1, 0);
                lcd.printf("BUZZING...");
                wait(5);

            }
        printf("LSM6DS0 [acc/mg]:%6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    }
    if (lock_unlock != 0)
        {
            printf("UNLOCKED\r\n");
            lcd.setCursorPosition(0, 15);
            lcd.printf(" ");//means unlock by removing the s on LCD
            printf("SecuritySystemOFF\r\n");
            }
     if(mybutton == 0)
    {
            temp=0;
            lcd.setBackLight(true);
            while(mybutton==0 and temp<500){
                wait(0.01);
                temp++;
            }
            if (temp==500){
                    lock_unlock =! lock_unlock;
                    if (lock_unlock==0){
                        lcd.setCursorPosition(0, 15);
                        lcd.printf("S");//means lock by adding a s on LCD             
                    }
                    if (lock_unlock==1){
                        lcd.setCursorPosition(0, 15);
                        lcd.printf(" ");//means unlock by removing the s on LCD             
                    }
                }
            
            wait(0.2);
            lcd.setBackLight(false);
    }
    lcd.setBackLight(false);
    wait(0.3);
  }
}
