#include "mbed.h"
#include "TPA81new.h"
#include "SRF05.h"
#include "Uvtron.h"
#include "Stepper.h"
#include "AMG8833.h"
#include "Adafruit_ADS1015.h"

// Konstanta
#define WAIT_TIME 0.02
// infrared
#define a_depan 5000000
#define b_depan 1.229
#define a_ads 500000
#define b_ads 1.184
#define I2C_ADDR 0xC0

Serial pc(USBTX,USBRX, 115200);

// AMG
Adafruit_AMG88xx amg(PB_3, PB_10); // sda, scl
float pixels[AMG88xx_PIXEL_ARRAY_SIZE];

DigitalOut relay(PB_2);
Uvtron uv(PC_12);
DigitalIn sound(PA_9);
AnalogIn line(PC_1);

// Infrared
// atas
AnalogIn ira1(PC_5);
AnalogIn ira2(PA_5);
AnalogIn ira3(PC_2);
AnalogIn ira4(PC_3);
AnalogIn ira5(PC_4);
AnalogIn ira6(PB_1);
AnalogIn ira7(PA_7);
AnalogIn ira8(PA_6);
// bawah
AnalogIn irb1(PA_0);
AnalogIn irb2(PA_1);
AnalogIn irb3(PA_4);
AnalogIn irb4(PB_0);
// ADC
I2C ads_i2c(PB_9, PB_8); // sda, scl
Adafruit_ADS1015 ads(&ads_i2c);

// kompas
I2C cmps12(PB_4, PA_8); //sda, scl

// stepper(PinName _en, PinName ms1, PinName ms2, PinName ms3, PinName _stepPin, PinName dir);
stepper s(PC_8, PC_6, PA_12, PA_11, PB_12, PC_7);

// sound
//DigitalIn sound(PA_9);

DigitalOut led_api(PB_6);
DigitalOut led_sound(PH_1);

float call_depan(uint16_t x)
{
    float side_distance = a_depan/pow(x,b_depan)+1;
    return side_distance;
}

float call_ads(uint16_t ir) {
    float voltage = ir * 6.2676 * 10e-5; // ubah ke mV
    uint16_t x = (voltage/3.3f) * 0xFFFF; // ubah ke uint16_t sesuai max nucleo
    float dist = a_ads/pow(x, b_ads)+1;    
    return dist;
}

int main()
{
    uint16_t ads_raw[4] = {};
    int status = amg.begin(AMG88xx_ADDRESS);
    amg.setMovingAverageMode(1);
    if (!status) {
        pc.printf("Could not find a valid AMG88xx sensor, check wiring! \n");
        while (1);
    }
    relay = 1;
    wait_ms(100);
    while (sound.read() == 1){
        wait_ms(100);    
    };
    pc.printf("Sound detected\n");
    while (1) {
        led_sound = 1;
        // IR
        for (uint8_t i=0; i < 4; i++) {
            ads_raw[i] = ads.readADC_SingleEnded(i);
            wait_ms(10);
        }; 
        uint16_t raw_a1 = ira1.read_u16();
        uint16_t raw_a2 = ira2.read_u16();
        uint16_t raw_a3 = ira3.read_u16();
        uint16_t raw_a4 = ira4.read_u16();
        uint16_t raw_a5 = ira5.read_u16();
        uint16_t raw_a6 = ira6.read_u16();
        uint16_t raw_a7 = ira7.read_u16();
        uint16_t raw_a8 = ira8.read_u16();

        uint16_t raw_b1 = irb1.read_u16();
        uint16_t raw_b2 = irb2.read_u16();
        uint16_t raw_b3 = irb3.read_u16();
        uint16_t raw_b4 = irb4.read_u16();

        float dist_a1 = call_depan(raw_a1);
        float dist_a2 = call_depan(raw_a2);
        float dist_a3 = call_depan(raw_a3);
        float dist_a4 = call_depan(raw_a4);
        float dist_a5 = call_depan(raw_a5);
        float dist_a6 = call_depan(raw_a6);
        float dist_a7 = call_depan(raw_a7);
        float dist_a8 = call_depan(raw_a8);
        float dist_a9 = call_ads(ads_raw[1]);
        float dist_a10 = call_ads(ads_raw[3]);
        float dist_a11 = call_ads(ads_raw[2]);
        float dist_a12 = call_ads(ads_raw[0]);
        float dist_b1 = call_depan(raw_b1);
        float dist_b2 = call_depan(raw_b2);
        float dist_b3 = call_depan(raw_b3);
        float dist_b4 = call_depan(raw_b4);

        pc.printf("ir atas\n");
        pc.printf("%.2f   %.2f %.2f   %.2f\n", dist_a9, dist_a10, dist_a11, dist_a12);
        pc.printf("%.2f               %.2f\n", dist_a3, dist_a1);
        pc.printf("%.2f               %.2f\n", dist_a4, dist_a6);
        pc.printf("%.2f   %.2f %.2f   %.2f\n", dist_a2, dist_a8, dist_a7, dist_a5);

        pc.printf("ir bawah\n");
        pc.printf("      %.2f\n", dist_b1);
        pc.printf("%.2f            %.2f\n", dist_b2, dist_b3);
        pc.printf("      %.2f\n", dist_b4);
        
        // baca amg
        float therm_temp = amg.readThermistor();
        amg.readPixels(pixels);
        pc.printf("%.2f\n", therm_temp);
        float max_temp = pixels[0];
        int max_i = 0;
        float sum_temp = 0;
        for (int i = 1; i <= AMG88xx_PIXEL_ARRAY_SIZE; i++) {
//            pc.printf("%.2f ", pixels[i-1]);   
//            if (i % 8 == 0) pc.printf("\n");
            if (pixels[i-1] > max_temp) {
                max_temp = pixels[i-1];
                max_i = i;
            }
            sum_temp += pixels[i-1];
        }
        
        // uvtron
        uv.Read();
        int read = uv.Flag;
        if (read) pc.printf("FIRE DETECTED\n");
        else pc.printf("NOT DETECTED\n");
        
        pc.printf("temp max= %.2f at %d\n", max_temp, max_i);
        pc.printf("temp rata2 = %.2f\n", sum_temp/AMG88xx_PIXEL_ARRAY_SIZE);
        
        // baca kompas
        char data[2] = {0x1, 0xFF};
        int nack;
        nack = cmps12.write(I2C_ADDR, data, 1);   
        nack = cmps12.read(I2C_ADDR, data+1, 1);
        pc.printf("Bearing kompas = %.2f\n", (float) data[1]/255*360);
        
        // stepper
        pc.printf("Stepper \n");
        for (int i = 0; i < 50; i++) {
            s.step(1, 1, 1/WAIT_TIME); // CCW
        }
        
        for (int i = 0; i < 50; i++) {
            s.step(1, 0, 1/WAIT_TIME); // CW
        }
        
        // pompa 
        relay = 0; // active low
        pc.printf("Pompa on!\n");
        wait(1);
        relay = 1;
        pc.printf("Pompa off\n");
        wait(1);
        
        wait_ms(200);
        
        pc.printf("\033[2J\033[H");
    }
}
