#include "mbed.h"

#define def_a 330377
#define def_b -1.349f

class SharpIR{
public:
    // Konstruktor SharpIR
    // @param apin pin AnalogIn yang tersambung ke sensor
    SharpIR(PinName apin);
    // Konstruktor SharpIR
    // @param apin pin AnalogIn yang tersambung ke sensor
    // @param a nilai dari int a, tergantung kalibrasi
    // @param b nilai dari float b, tergantung kalibrasi
    // @note jarak diperoleh dari hasil pembacaan dengan rumus a*pow(meas, b), dimana meas nilai tegangan output sensor
    SharpIR(PinName apin, int a, float b);
    // Baca data dari sensor
    // @return jarak hasil pembacaan dalam cm
    float read();
private:
    AnalogIn _ain;  
    float _a;
    float _b;
};