#include "SharpIR.h"

SharpIR::SharpIR(PinName apin) : _ain(apin), _a(def_a), _b(def_b) 
{
}

SharpIR::SharpIR(PinName apin, int a, float b) : _ain(apin), _a(a), _b(b)
{
}

float SharpIR::read()
{
    float meas = _ain.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    meas = meas * 3300; // Change the value to be in the 0 to 3300 range
    float dist = _a * pow(meas , _b);
    return dist;   
}