#include "mbed.h"
#include "AMG8833.h"

Serial pc(USBTX,USBRX, 115200);
Adafruit_AMG88xx amg(PB_9, PB_8);

float pixels[AMG88xx_PIXEL_ARRAY_SIZE];

int main()
{
    int status = amg.begin(AMG88xx_ADDRESS);
    amg.setMovingAverageMode(1);
    if (!status) {
        pc.printf("Could not find a valid AMG88xx sensor, check wiring! \n");
        while (1);
    }
    wait_ms(100);
    while (1) {
        float therm_temp = amg.readThermistor();
        amg.readPixels(pixels);
        pc.printf("%.2f\n", therm_temp);
        float max_temp = pixels[0];
        int max_i = 0;
        float sum_temp = 0;
        for (int i = 1; i <= AMG88xx_PIXEL_ARRAY_SIZE; i++) {
//            pc.printf("%.2f ", pixels[i-1]);   
//            if (i % 8 == 0) pc.printf("\n");
            if (pixels[i-1] > max_temp) {
                max_temp = pixels[i-1];
                max_i = i;
            }
            sum_temp += pixels[i-1];
        }
        for (int i = 1; i <= AMG88xx_PIXEL_ARRAY_SIZE; i++) {
            pc.printf("%.2f", pixels[i-1]);   
            if (i == max_i) {
                pc.printf("_ ");
            }
            else {
                pc.printf("  ");
            }
            if (i % 8 == 0) pc.printf("\n");
//            if (pixels[i-1] > max_temp) {
//                max_temp = pixels[i-1];
//                max_i = i-1;
//            }
//            sum_temp += pixels[i-1];
        }
        pc.printf("temp max= %.2f at %d\n", max_temp, max_i);
        pc.printf("temp rata2 = %.2f", sum_temp/AMG88xx_PIXEL_ARRAY_SIZE);
        wait(0.2);
        pc.printf("\033[2J\033[H");
    }
}
