#include "mbed.h"
#include "MSCFileSystem.h"
#include "INA226.hpp"
//#include "EthernetInterface.h"
//#include "NTPClient.h"
#include "C12832_lcd.h"
#include "MMA7660.h"
#include "LM75B.h"

Serial debug(USBTX,USBRX);
DigitalOut ntpLed(LED1);
DigitalOut mmaLed(LED2);
DigitalOut inaLed(LED3);
DigitalOut usbLed(LED4);

time_t ctTime;

// gloval variavle
unsigned short val;
double V1,V2,C1,C2;
char strTimeMsg[16];
float xyz[3];
float r_V1,r_V2,r_C1,r_C2;
float r_rpm;

// INA226
I2C i2c(p28,p27);
INA226 VCmonitor1(i2c,0x80);
INA226 VCmonitor2(i2c,0x83);

// Analog In
AnalogIn rpm_in(p17);

// mbed application board LCD
C12832_LCD lcd;

// for NTP Client
//EthernetInterface eth;
//NTPClient ntp;

// MMA7660 accelerometer 0x98
MMA7660 MMA(p28,p27);

// LM75B Temperture
LM75B tmp(p28,p27);

//USB Flash
MSCFileSystem msc("fs");

// set INA226
void setINA226(){
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Please waite...INA226");
    inaLed = 1;
 
 // VCmonitor1
    if ( !VCmonitor1.isExist() ){
        lcd.printf("VCmonitor1 INA226 Not Found.\n");
        inaLed = 0;
    }
    lcd.printf("VCmonitor1 INA226 Found\n");
    val = 0;
    if ( VCmonitor1.rawRead(0x00,&val) != 0){
        lcd.printf("VCmonitor1 INA226 Read Error\n");
        debug.printf("VCmonitor1 INA226 Read Error\n");
    }
    lcd.printf("VCmonitor1 Reg 0x00 : 0x%04x\n",val);
    debug.printf("VCmonitor1 Reg 0x00 : 0x%04x\r\n",val);

    VCmonitor1.setCurrentCalibration();

// VCmonitor2
    if ( !VCmonitor2.isExist() ){
        lcd.printf("VCmonitor2 INA226 Not Found.\n");
        inaLed = 0;
    }
    lcd.printf("VCmonitor2 INA226 Found\n");
    val = 0;
    if ( VCmonitor2.rawRead(0x00,&val) != 0){
        lcd.printf("VCmonitor2 INA226 Read Error\n");
        debug.printf("VCmonitor2 INA226 Read Error\n");
    }
    lcd.printf("VCmonitor2 Reg 0x00 : 0x04x\n",val);
    debug.printf("VCmonitor2 Reg 0x00 : 0x04x\r\n",val);
    
    VCmonitor2.setCurrentCalibration();
}

// set MMA7660
void setMMA7660(){
    if ( MMA.testConnection() ){
        mmaLed = 1;
    }
}

// update LCD Display
void updateLCD() {

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s",strTimeMsg);
    
    lcd.locate(0,10);
    lcd.printf("%3.2f  ",xyz[0]);
    lcd.printf("%3.2f  ",xyz[1]);
    lcd.printf("%3.2f  ",xyz[2]);
    
    lcd.locate(0,20);
    lcd.printf("%3.2f  ",r_V1);
    lcd.printf("%3.2f  ",r_C1);
    lcd.printf("%3.2f  ",r_rpm);

    debug.printf("%s,%4.3f,%4.3f,%4.3f,%f,%f,%f,%f,%f,%f\r\n",strTimeMsg,xyz[0],xyz[1],xyz[2],r_V1,r_C1,r_V2,r_C2,r_rpm,tmp.read());
       
}

/*  ----- Set RTC by NTP  ----- */
/* ----------------
void setRTC_NTP()
{
 
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Get IP addr ...");

    EthernetErr ethErr = eth.setup();
    
    if (ethErr) {
        lcd.cls();
        lcd.printf("Network Error \n\r %d",ethErr);
        return ;
    }
      
    Host server(IpAddr(), 123, "0,pool.ntp.org");
    ntp.setTime(server);
    lcd.printf("Set time successfully");
    ctTime = time(NULL);
    ntpLed = 1;
 //   eth.disconnect();
 }
 ----------- */

int main() {

    char strTimeFile[8];
    int intTimeFile=0;
    char filepath[256];
    double V,C;
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("init...");
    
    time_t ctTime;
    
// set RTC by NTP
//    setRTC_NTP();
    
// set INA226
    setINA226();
    
// set MMA7660
    setMMA7660();

    while(1){
    
        ctTime = time(NULL) + 32400;
        strftime(strTimeFile,8,"%d%H%M%S",localtime(&ctTime));
        
        lcd.cls();
        lcd.printf("USB File Create...\n");
        debug.printf("%s\r\n",strTimeFile);
            
        intTimeFile = atoi(strTimeFile);
        sprintf(filepath,"/fs/%08u.csv",intTimeFile);
        lcd.printf("%.16s ",filepath);
        debug.printf("filepath %s\r\n",filepath);
        FILE *fp = fopen(filepath,"w");
        usbLed = 1;
        if (fp == NULL ) {
            lcd.locate(0,12);
            lcd.printf("Create Failed.") ;
//            exit(0);
        }

        for (int i=0; i<600; i++) {        
            VCmonitor1.getVoltage(&V1);
            VCmonitor1.getCurrent(&C1);
            r_V1 = V1 / 1000 ;
            r_C1 = C1 / 1000 ;
            VCmonitor2.getVoltage(&V2);
            VCmonitor2.getCurrent(&C2);
            r_V2 = V2 / 1000 ;
            r_C2 = C2 / 1000 ;
        
            r_rpm = rpm_in.read() * 18500 ;
        
           xyz[0] = MMA.x();
           xyz[1] = MMA.y();
           xyz[2] = MMA.z();
           
           ctTime = time(NULL) + 32400;
           strftime(strTimeMsg,16,"%m/%d %H:%M:%S",localtime(&ctTime));
        
           fprintf(fp,"%s,%4.3f,%4.3f,%4.3f,%f,%f,%f,%f,%f,%f\r\n",strTimeMsg,xyz[0],xyz[1],xyz[2],r_V1,r_C1,r_V2,r_C2,r_rpm,tmp.read());
           updateLCD();
           
           wait(1);
        }
        
        fclose(fp);
        usbLed = 0;
    }
}
