#ifndef _MD_PID_H_
#define _MD_PID_H_

#include "MD.h"
#include "QEI.h"

class MD_PID
{
public:
    MD_PID();
    MD_PID( MD *motor_,
            double kp_, double ki_, double kd_, int pulse_, QEI *qei_);
    double Drive(int a, double ref, double stop);
    double PID(double target);
    void Read_Speed();
    double Speed();
    void Reset();

    void PID_Step(double interval);
private:
    double ref1;
    double duty;

    double diff[2];
    double integral;
    double delta;
    double p, i, d;
    double kp, ki, kd;
    int pulse;
    double qs;

    QEI *qei;
    MD *md;
    Timer timer;
};

MD_PID* Create_MD_PID(  PinName channelA, PinName channelB, PinName index, int pulsesPerRev, QEI::Encoding encoding, double kp, double ki, double kd, int pulse, PinName pwm, PinName dere);

#endif