#include "I2CTransporter.h"

I2CTransporter::I2CTransporter(I2C *master_)
{
    _master = master_;
    address = 0;
    target_array = NULL;
    Transport_Began = false;
}
    
void I2CTransporter::transport_begin(int addr_, char *target_array_, int data_size_)
{
    address = addr_ ;
    target_array = target_array_;
    data_size = data_size_;
    Transport_Began = true;  
}   

bool I2CTransporter::read()
{
    if(Transport_Began == true)
    {
        return _master->read(address, target_array, data_size) == 0
            ? true 
            : false;
    }
    else
    {
        return false;
    }
}

bool I2CTransporter::write()
{
    if(Transport_Began == true)
    {
        return _master->write(address, target_array, data_size) == 0
            ? true 
            : false;
    }
    else
    {
        return false;
    }
}

void I2CTransporter::transport_end()
{
    if(Transport_Began == true)
    {
        address = 0;
        target_array = NULL;
        data_size = 0;
        Transport_Began = false;  
    }
    else
    {
    }
}