#include "mbed.h"

#include "DataPool.h"
#include "AlphaTransporter.h"
#include "BoolProcess.h"

#include "2017_3_h.h"

#define SDA PB_7
#define SCL PB_6

I2C *master;
DataPool *beta;

Omni_3 Omni(PB_4, PB_0, PA_7, PA_12, PB_5, PB_1, PA_5, PA_6, PA_11, PF_0, PA_3, PA_4, 1);
Serial pc(USBTX, USBRX);

int main()
{
    master = new I2C(SDA, SCL);
    beta = new AlphaTransporter(master);

    Omni.Drive(0, 0, 0, 0);
    float /*a, */x, y, t;
    while(1)
    {
        beta->set();
        //a = beta->read(3);
        x = beta->read(0) / 128.00 * -1.00;
        y = beta->read(1) / 128.00 * -1.00;
        t = beta->read(2) / 128.00 * -1.00;
        
        Omni.Drive(0, x, y, t);
            
        wait(0.01);
    }
}
